// uvikodoc.cpp : implementation of the CUvikonDoc class
//

#include "stdafx.h"
#include "uvikon.h"
#include "listview.h"
#include "uvikovw.h"

#include <afxwin.h>
#include <stdlib.h>
//#include "uvikodoc.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CUvikonDoc

IMPLEMENT_DYNCREATE(CUvikonDoc, CDocument)

BEGIN_MESSAGE_MAP(CUvikonDoc, CDocument)
	//{{AFX_MSG_MAP(CUvikonDoc)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUvikonDoc construction/destruction

CUvikonDoc::CUvikonDoc()
{
	// TODO: add one-time construction code here
	m_nCurrentRun = -1;
	m_bFirstFix = TRUE;
	m_nSelected = 0;
	m_nSelExtent = 0;
	m_nUndoType = UNDO_NOTAVAIL;
	m_DocSize = (0, 0);
}

CUvikonDoc::~CUvikonDoc()
{
	int i;
	
	for (i = 0; i < m_Data.GetSize(); i++)
	{
		delete (CData*)m_Data.GetAt(i);      // remove all items in the array
	}
	
	for (i = 0; i < m_UndoData.GetSize(); i++)
	{
		delete (CData*)m_UndoData.GetAt(i);      // remove all items in the array
	}
}

BOOL CUvikonDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CUvikonDoc serialization

void CUvikonDoc::Serialize(CArchive& ar)
{
	CDocument::Serialize(ar);
	
	if (ar.IsStoring())
	{
		m_Data.Serialize(ar);       // let our data serialize themselves
		ar.Write(&m_nCurrentRun, sizeof(m_nCurrentRun)); // save current run No.
		// m_bFirstFix need not be serialized: always true after loading
	}
	else
	{
		m_Data.Serialize(ar);
		ar.Read(&m_nCurrentRun, sizeof(m_nCurrentRun));
	}
}

/////////////////////////////////////////////////////////////////////////////
// CUvikonDoc diagnostics

#ifdef _DEBUG
void CUvikonDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CUvikonDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

///////////////////////////////////////////////////////////////////////////
// CUvikonDoc initialization helper

//////////////////////////////////////////////////////////////////////////
// InitializeListBox(): Called by CListView::OnInitialUpdate, used to fill the
//                listbox with the starting values
//////////////////////////////////////////////////////////////////////////
void CUvikonDoc::InitializeListBox(CDC* pDC, TEXTMETRIC* pTm)
{
	SetDocSize(pDC, pTm);
		
	// change the selection
	if (m_nCurrentRun >= 0)
	{
		((CData*)(m_Data.GetAt(m_nCurrentRun)))->m_bSelected = TRUE;
		m_nSelected = 1;
	}
	
	UpdateAllViews(NULL, MAKELONG(FALSE, TRUE), NULL);
}

/////////////////////////////////////////////////////////////////////////////
// CUvikonDoc commands

////////////////////////////////////////////////////////////////////////////
// StartNewRun(): Starts a new run in the document, creates a new CData object
//                to store the data and updates the CListView-embedded listbox
// Arguments: pszTitle: ptr to CString containing title of run
//            nMethod: currently selected method
//			  nCXSize: x-Size of new title string
//            pTm: ptr to TEXTMETRIC structure containing metric info
// Return: BOOL TRUE if successful, FALSE if error
////////////////////////////////////////////////////////////////////////////
BOOL CUvikonDoc::StartNewRun(CString* pszTitle, int nMethod, int nCXSize, TEXTMETRIC* pTm)
{
	CData* pData;
	int nNewRun;
	
															// and set selection to current run
	TRY
	{
		// Create a new CData object
		pData = new CData;
		pData->m_szTitle = *pszTitle;
		nNewRun = m_Data.Add(pData);
		pData->m_nMethod = nMethod;
	}
	CATCH(CException, e)
	{
		return FALSE;
	}
	END_CATCH
    
    m_PrevDocSize = m_DocSize;
    
    nCXSize += DOC_LEFTMARGIN + DOC_RIGHTMARGIN;
    if (nCXSize > m_DocSize.cx)    // adjust doc size
    {
    	m_DocSize.cx = nCXSize;
    }
	m_DocSize.cy = (m_Data.GetSize())*(pTm->tmHeight + DOC_LINESPACE);
    
	SetCurrentRun(nNewRun, TRUE);
	  
    // mark document as changed
    SetModifiedFlag(TRUE);
    
    m_nUndoType = UNDO_ADD;
    m_nPrevIndex = m_nCurrentRun;
    
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// UpdateRun(): Updates document data member to reflect the changes in CEdit
// Argument: Data: Reference to CEdit member of CUvikonView containing the data
/////////////////////////////////////////////////////////////////////////////
void CUvikonDoc::UpdateRun(CEdit& Data)
{
	
	if (m_Data.GetSize() > 0)
	{
	    if (Data.GetModify())
	    {
			Data.GetWindowText(((CData*)(m_Data.GetAt(m_nCurrentRun)))->m_szData);
	
	    	// mark document as changed
	    	SetModifiedFlag(TRUE);
	    	Data.SetModify(FALSE);      // reset CEdit change flag
	    }
	}
}

//////////////////////////////////////////////////////////////////////////////
// CUvikonDoc selection functions

//////////////////////////////////////////////////////////////////////////////
// SetCurrentRun(): Sets the current run and updates the associated views
// Arguments: nRun: new current run
//            bScrollToPos: If TRUE, doc will be scrolled to end of doc
//////////////////////////////////////////////////////////////////////////////
void CUvikonDoc::SetCurrentRun(int nRun, BOOL bScrollToPos)
{
	int nMaxSize = m_Data.GetSize();
	int i;
	int *pArray;
	HLOCAL hLocal;
	
	CListView* pListView = (CListView*)GetListView();
		
	if (nMaxSize == 0)
	{
		m_nCurrentRun = -1;
		UpdateAllViews(NULL, MAKELONG(FALSE, TRUE), NULL);
		return;
	}
	else if (nRun >= nMaxSize)
	{
		m_nCurrentRun = nMaxSize - 1;
	}
	else if (nRun < 0)
	{
		m_nCurrentRun = 0;
	}
	else
	{
		m_nCurrentRun = nRun;
	}
	
	// get list of selected items
	hLocal = LocalAlloc(LMEM_FIXED, m_nSelected*sizeof(int));
	pArray = (int*)hLocal;                   // alloc mem for array to hold indices
	GetSelItems(pArray);  	// fill array with indices
		
	TRY
	{
		for (i = 0; i < m_nSelected; i++)
		{
			((CData*)(m_Data.GetAt(pArray[i])))->m_bSelected = FALSE;
			m_UpdateIndex.Add(pArray[i]);
		}
		
		m_nSelected = 1;
	    m_nSelExtent = 0;
	    
		((CData*)(m_Data.GetAt(m_nCurrentRun)))->m_bSelected = TRUE;
		m_UpdateIndex.Add(m_nCurrentRun);
	}
	CATCH(CException, e)
	{
		((CData*)(m_Data.GetAt(m_nCurrentRun)))->m_bSelected = TRUE;  // make sure that current run is selected
	    AfxMessageBox("Out of memory: Please save document and close other apps", MB_OK|MB_ICONSTOP);
	}
	END_CATCH
	
	UpdateAllViews(NULL, MAKELONG(bScrollToPos, TRUE), this);
}

////////////////////////////////////////////////////////////////////////////////
// SetCurrentRunRel(): Sets current run relative to current position. Translates
//                     up and down arrow key presses to calls to SetCurrentRun
// Argument: bUp: index of current run is incremented if TRUE, decremented if FALSE
// Return: index of current run when finished
////////////////////////////////////////////////////////////////////////////////
int CUvikonDoc::SetCurrentRunRel(BOOL bUp)
{
	if (bUp)
	{
		SetCurrentRun(m_nCurrentRun + 1, FALSE);
	}
	else
	{
		SetCurrentRun(m_nCurrentRun - 1, FALSE);
	}
	return m_nCurrentRun;
}

/////////////////////////////////////////////////////////////////////////////////
// SelectRange(): Selects a range of items, starting at the current run
// Argument: nAnchorLine: the index of the line where the current selection range
//                        was started. This is not necessarily identical to 
//                        m_nCurrentRun, if several blocks of lines are selected
//                        by using the ctrl key
//           nIndex: index of item to extend selection to
// The code is still a bit ugly, might be done simpler!!
/////////////////////////////////////////////////////////////////////////////////
void CUvikonDoc::SelectRange(int nAnchorLine, int nIndex)
{
	int i, nStart, nStop, nUpBound, nNewSelExtent;
	BOOL bNegSelect, bPosSelect;
	
	if (m_Data.GetSize() > 0)
	{
		// ensure that nIndex is within the limits of existing data
		nUpBound = m_Data.GetUpperBound();
		nIndex = (nIndex > nUpBound) ? nUpBound : nIndex;
		nIndex = (nIndex < 0) ? 0 : nIndex;
		
		// compute the range where changes of selection state actually happen
		nNewSelExtent = nIndex - nAnchorLine;
		nStart = nAnchorLine + m_nSelExtent;
		nStop = nStart + nNewSelExtent - m_nSelExtent;
		
		if (nStart > nStop)       // sort in increasing order
		{
			nUpBound = nStart;
			nStart = nStop;
			nStop = nUpBound;
		}
		
		// m_nSelExtent will always be different from nNewSelExtent
		if (nNewSelExtent > 0)
		{
			if (m_nSelExtent < nNewSelExtent)
			{
				bNegSelect = FALSE;
				bPosSelect = TRUE;
				if (m_nSelExtent > 0)
				{
					nStart++;
				}
			}
			else
			{
				bPosSelect = FALSE;
				nStart++;
			}
		}
		else
		{
			if (m_nSelExtent > nNewSelExtent)
			{
				bNegSelect = TRUE;
				bPosSelect = FALSE;
				if (m_nSelExtent < 0)
				{
					nStop--;
				}
			}
			else
			{
				bNegSelect = FALSE;
				nStop--;
			}
		}
		
		// now change the lines that actually need it
		if (nStart < nAnchorLine && nAnchorLine < nStop)
		{
			for (i = nStart; i < nAnchorLine; i++)
			{
				ToggleItemSelection(i, FALSE, bNegSelect);
			}
			for (i = nAnchorLine; i <= nStop; i++)
			{
				ToggleItemSelection(i, FALSE, bPosSelect);
			}
		}
		else if (nStop <= nAnchorLine)
		{
			for (i = nStart; i <= nStop; i++)
			{
				ToggleItemSelection(i, FALSE, bNegSelect);
			}
		}
		else
		{
			for (i = nStart; i <= nStop; i++)
			{
				ToggleItemSelection(i, FALSE, bPosSelect);
			}
		}
		m_nSelExtent = nNewSelExtent;
	}
    
}

////////////////////////////////////////////////////////////////////////////
// ResetSelExtent(): Resets the m_nSelExtent selection variable. Called by
//                   CListView after the current selection range has been
//                   finished
////////////////////////////////////////////////////////////////////////////
void CUvikonDoc::ResetSelExtent()
{
	m_nSelExtent = 0;
}

/////////////////////////////////////////////////////////////////////////////////
// GetSelItems(): Fills an array with the indices of the currently selected items
// Argument: rgIndex: ptr to int array to hold the indices. The size of the array
//                    must be at least CListView::m_bSelected.
// Return: int The number of actually written indices
/////////////////////////////////////////////////////////////////////////////////
int CUvikonDoc::GetSelItems(LPINT rgIndex)
{
	int i;
	int rgi = 0;
	
	for (i = 0; i < m_Data.GetSize(); i++)       // walk thru all runs
	{
		if (((CData*)(m_Data.GetAt(i)))->m_bSelected)
		{
			rgIndex[rgi++] = i;
		}	
	}
	return rgi;
}

/////////////////////////////////////////////////////////////////////////
// GetNumSelected(): Returns number of selected items
// Return: int number of selected items
/////////////////////////////////////////////////////////////////////////
int CUvikonDoc::GetNumSelected()
{
	return m_nSelected;
}

////////////////////////////////////////////////////////////////////////////
// ToggleItemSelection(): Toggles selection state of item
// Arguments: nIndex: index of item to toggle
//            bToggle: TRUE if we toggle, FALSE if we set value explicitely
//            bNewState: new TRUE/FALSE value if toggle is TRUE, not used
//                      if toggle is false
////////////////////////////////////////////////////////////////////////////
void CUvikonDoc::ToggleItemSelection(int nIndex, BOOL bToggle, BOOL bNewState)
{
	BOOL bCurrentVal;
	int nMaxSize = m_Data.GetSize();
		
	if (nMaxSize > 0 && nIndex < nMaxSize && nIndex != m_nCurrentRun)
	{
		bCurrentVal = ((CData*)(m_Data.GetAt(nIndex)))->m_bSelected;
		if (bToggle)
		{
			((CData*)(m_Data.GetAt(nIndex)))->m_bSelected = (bCurrentVal) ? FALSE:TRUE;
			if (bCurrentVal)
			{
				m_nSelected--;
			}
			else
			{
			    m_nSelected++;
			}
		}
		else
		{
		    ((CData*)(m_Data.GetAt(nIndex)))->m_bSelected = bNewState;
		    if (bNewState != bCurrentVal)
		    {
		    	if (bNewState)
		    	{
		    		m_nSelected++;
		    	}
		    	else
		    	{
		    		m_nSelected--;
		    	}
		    }
		}
		
		
		TRY
		{
			m_UpdateIndex.Add(nIndex);
		}
		CATCH(CException, e)
		{
	    	AfxMessageBox("Out of memory: Please save document and close other apps", MB_OK|MB_ICONSTOP);
		}
		END_CATCH
		
		UpdateAllViews(NULL, 0L, this);
	}
}

////////////////////////////////////////////////////////////////////////////
// CUvikonDoc edit menu support

////////////////////////////////////////////////////////////////////////////
// EditClear(): Deletes the selected run
// Argument: bAll: All items are deleted if TRUE, selected ones if FALSE
//           pDC: ptr to device context
//           pTm: ptr to TEXTMETRIC struct holding metric info
////////////////////////////////////////////////////////////////////////////
void CUvikonDoc::EditClear(BOOL bAll, CDC* pDC, TEXTMETRIC* pTm)
{
	int *pArray;
	int i, nNewSelection, nSelected;
	HLOCAL hLocal;
	
	if (m_nSelected > 1)
	{
		ClearUndoBuffer();
	}
	
	if (bAll)
	{
		TRY
		{
			for (i = 0; i < m_Data.GetSize(); i++)
			{
				((CData*)(m_Data.GetAt(0)))->m_bSelected = FALSE;
				m_UndoIndex.Add((UINT)i);
				m_UndoData.Add(m_Data.GetAt(0));	// copy ptr to undo array
				m_Data.RemoveAt(0, 1);   // then remove the ptr in the data array
				m_UpdateIndex.Add(i);
			}
		}
		CATCH(CException, e)
		{
	    	AfxMessageBox("Out of memory: Please save document and close other apps", MB_OK|MB_ICONSTOP);
		    return;
		}
		END_CATCH
		
		m_nSelected = 0;
	}
	else
	{
		hLocal = LocalAlloc(LMEM_FIXED, m_nSelected*sizeof(int));
		pArray = (int*)hLocal;                   // alloc mem for array to hold indices
		GetSelItems(pArray);  	// fill array with indices
		SortArray(pArray, m_nSelected);               // sort in descending order
		
		nSelected = m_nSelected;
		
		TRY
		{
			for (i = 0; i < nSelected; i++)
			{
				m_UndoIndex.Add((UINT)(pArray[i]));
				m_UndoData.Add(m_Data.GetAt(pArray[i]));	// copy ptr to undo array
				((CData*)(m_UndoData.GetAt(m_UndoData.GetUpperBound())))->m_bSelected = FALSE;
				m_Data.RemoveAt(pArray[i], 1);   // then remove the ptr in the data array
				m_nSelected--;
				m_UpdateIndex.Add(pArray[i]);
			}
		}
		CATCH(CException, e)
		{
	    	LocalFree(hLocal);
	    	AfxMessageBox("Out of memory: Please save document and close other apps", MB_OK|MB_ICONSTOP);
		    return;
		}
		END_CATCH
		
		nNewSelection = pArray[i-1]-1;
		LocalFree(hLocal);
	}
	m_nUndoType = UNDO_CLEAR;
    m_PrevDocSize = m_DocSize;
	
	// mark document as modified
	SetModifiedFlag(TRUE);
	
	SetDocSize(pDC, pTm);
	// TODO: remove this line by adjusting m_UpdateIndex correctly (a few lines up)
	UpdateAllViews(NULL, 0L, NULL);
	// change the selection
	SetCurrentRun(nNewSelection, FALSE);
    
}

///////////////////////////////////////////////////////////////////////////
// Undo(): Undoes the latest action on the listbox
// Supports two undo types:
//        UNDO_CLEAR: Used in Clear, Clear all, cut edit commands
//        UNDO_ADD: Used in Paste and Run sample command
///////////////////////////////////////////////////////////////////////////
void CUvikonDoc::Undo()
{
	int i, nSize;
	
	m_DocSize = m_PrevDocSize;
	
	if (m_nUndoType == UNDO_CLEAR)
	{
		nSize = m_UndoIndex.GetSize();
		
		TRY
		{
			for (i = nSize - 1; i >= 0; i--)
			{
				m_Data.InsertAt((int)(m_UndoIndex.GetAt(i)), m_UndoData.GetAt(i), 1);
				SetCurrentRun(m_UndoIndex.GetAt(i), FALSE);
				m_UndoIndex.RemoveAt(i);
				m_UndoData.RemoveAt(i);
			}
		}
		CATCH(CException, e)
		{
			AfxMessageBox("Out of memory - cannot undo clear", MB_OK|MB_ICONSTOP);
			m_nUndoType = UNDO_NOTAVAIL;
			return;
		}
		END_CATCH
		UpdateAllViews(NULL, 0L, NULL);
	}
	else if (m_nUndoType == UNDO_ADD)
	{
		delete (CData*)(m_Data.GetAt(m_nPrevIndex));
		m_Data.RemoveAt(m_nPrevIndex);
		SetCurrentRun(m_nPrevIndex - 1, FALSE);  
		UpdateAllViews(NULL, 0L, NULL);
	}
	else if (m_nUndoType == UNDO_TITLEEDIT)
	{
		TRY
		{
			((CData*)(m_Data.GetAt(m_UndoIndex.GetAt(0))))->m_szTitle = ((CData*)(m_UndoData.GetAt(0)))->m_szTitle;
			delete (CData*)(m_UndoData.GetAt(0));
			m_UndoData.RemoveAt(0);
			m_UndoIndex.RemoveAt(0);
			m_UpdateIndex.Add(m_nCurrentRun);
			UpdateAllViews(NULL, 0L, this);
		}
		CATCH(CException, e)
		{
			AfxMessageBox("Out of memory - cannot undo title edit", MB_OK|MB_ICONSTOP);
			m_nUndoType = UNDO_NOTAVAIL;
			return;
		}
		END_CATCH
	}
	
	m_nUndoType = UNDO_NOTAVAIL; 	    // no more things to undo
	
	// mark document as modified
	SetModifiedFlag(TRUE);
}

////////////////////////////////////////////////////////////////////////////
// ClearUndoBuffer(): Clears undo buffer and actually deletes objects
////////////////////////////////////////////////////////////////////////////
void CUvikonDoc::ClearUndoBuffer()
{
	int i, nMaxSize;
	
	nMaxSize = m_UndoIndex.GetSize();
	
	for (i = 0; i < nMaxSize; i++)
	{
		delete m_UndoData.GetAt(0);
		m_UndoData.RemoveAt(0);
		m_UndoIndex.RemoveAt(0);
	}
	
	m_nUndoType = UNDO_NOTAVAIL; 	
}

//////////////////////////////////////////////////////////////////////////////
// IsUndo(): Helper to see whether there is something to undo
// Return: TRUE if something to undo, FALSE if not
//////////////////////////////////////////////////////////////////////////////
BOOL CUvikonDoc::IsUndo()
{
	return (m_nUndoType != UNDO_NOTAVAIL)/* ? TRUE:FALSE*/;
}

///////////////////////////////////////////////////////////////////////////////
// CopyToClpbd(): Copies data to clipboard as text string
///////////////////////////////////////////////////////////////////////////////
BOOL CUvikonDoc::CopyToClpbd()
{
	DWORD dwSize;
	CData* pData;
	HGLOBAL hClpbd;
	char* pClpbd;
	
	// Allocate enough memory to hold strings
	pData = (CData*)m_Data.GetAt(m_nCurrentRun);
	dwSize = (DWORD)(pData->m_szTitle.GetLength()) + 
			 (DWORD)(pData->m_szData.GetLength() + 3);    // leave space for \r\n\0
	
	hClpbd = GlobalAlloc(GMEM_MOVEABLE, dwSize);
	if (hClpbd == NULL)
	{
		return FALSE;
	}
	pClpbd = (char*)GlobalLock(hClpbd);
	if (pClpbd == NULL)
	{
		GlobalFree(hClpbd);
		return FALSE;
	}
	
	// copy strings to buffer
	strcpy(pClpbd, (const char*)(pData->m_szTitle));
	strcat(pClpbd, "\r\n");
	strcat(pClpbd, (const char*)(pData->m_szData));
	GlobalUnlock(hClpbd);
	
	// set clipboard data
	if (SetClipboardData(CF_TEXT, hClpbd) == NULL)
	{
		return FALSE;
	}
	
	return TRUE;
}

////////////////////////////////////////////////////////////////////////////////
// CopyFromClpbd(): Copies data from clipboard and tries to insert them as run
////////////////////////////////////////////////////////////////////////////////
void CUvikonDoc::CopyFromClpbd(CDC* pDC, TEXTMETRIC* pTm)
{
	CData* pData;
	CString szLBString;
	HANDLE hClpbd;
	DWORD dwClpbdSize;
	char *pszBuffer, *pszData;
	int nMethod, nSizeToCopy, i, nNewRun;
	CSize Extent;
	BOOL bNoData = FALSE;
	
	hClpbd = GetClipboardData(CF_TEXT);
	if (hClpbd == NULL)    // can't access data
	{
		return;
	}
	
	pszBuffer = (char*)GlobalLock(hClpbd);
	dwClpbdSize = GlobalSize(hClpbd);
	nSizeToCopy = (int)(UINT)((dwClpbdSize > MAXINT-1) ? MAXINT-1 : dwClpbdSize);
	
	pszData = (char*)memccpy(szLBString.GetBuffer(nSizeToCopy), pszBuffer, '\n', nSizeToCopy);
	szLBString.ReleaseBuffer(-1);
	if (pszData == NULL)
	{
		szLBString += "\0";
		bNoData = TRUE;	
	}
	i = szLBString.Find("\r\n");
	if (i > 0)
	szLBString = szLBString.Left(i);  // discard cr/lf in title
	
	if (strncmp(szLBString, "SCAN", 4) == 0)
	{
		nMethod = MET_LSCAN;
	}
	else if (strncmp(szLBString, "LFIX", 4) == 0)
	{
		nMethod = MET_LFIX;
	}
	else if (strncmp(szLBString, "TDRV", 4) == 0)
	{
		nMethod = MET_TDRIVE;
	}
	else         // no run type found
	{
		GlobalUnlock(hClpbd);
		AfxMessageBox("Cannot convert clipboard content to Uvikon run", MB_OK|MB_ICONSTOP);
		return;
	}
	
	TRY
	{
		// Create a new CData object
		pData = new CData;
		pData->m_szTitle = szLBString;
		nNewRun = m_Data.Add(pData);
		pData->m_nMethod = nMethod;
	}
	CATCH(CException, e)
	{
    	GlobalUnlock(hClpbd);
	    AfxMessageBox("Could not import clipboard data - out of memory", MB_OK|MB_ICONSTOP);
	    return;
	}
	END_CATCH
    
	
    if (pszData != NULL && !bNoData)
    {
		nSizeToCopy = (int)(UINT)((dwClpbdSize - szLBString.GetLength() > MAXINT-1) ? MAXINT-1 : dwClpbdSize - szLBString.GetLength());
		pszData = (char*)memccpy(pData->m_szData.GetBuffer(nSizeToCopy), pszBuffer+szLBString.GetLength()+2, '\0', nSizeToCopy);
		pData->m_szData.ReleaseBuffer(-1);
		if (pszData == NULL)
		{
			pData->m_szData += "\0";
			AfxMessageBox("Clipboard content was truncated at 64k during import", MB_OK|MB_ICONEXCLAMATION);
		}
    }
    
    GlobalUnlock(hClpbd);
	  
	m_PrevDocSize = m_DocSize;
	Extent = pDC->GetTabbedTextExtent(pData->m_szTitle, (pData->m_szTitle).GetLength(), 0, NULL);    
    Extent.cx += DOC_LEFTMARGIN + DOC_RIGHTMARGIN;
    if (Extent.cx > m_DocSize.cx)
    {
    	m_DocSize.cx = Extent.cx;
    }
	m_DocSize.cy = (m_Data.GetSize())*(pTm->tmHeight + DOC_LINESPACE);
    
    // mark document as changed
    SetModifiedFlag(TRUE);
 	SetCurrentRun(nNewRun, TRUE);
   
    m_nUndoType = UNDO_ADD;
    m_nPrevIndex = m_nCurrentRun;
}

////////////////////////////////////////////////////////////////////////////
// CUvikonDoc Get&Set helpers

////////////////////////////////////////////////////////////////////////////
// GetData(): Returns a ptr to the data of the current run
// Return: CString* ptr to data CString; NULL if no run in document
////////////////////////////////////////////////////////////////////////////
CString* CUvikonDoc::GetData()
{
	if (m_Data.GetSize() > 0)
	{
		return &(((CData*)(m_Data.GetAt(m_nCurrentRun)))->m_szData);	
	}
	else
	{
		return NULL;
	}
}

//////////////////////////////////////////////////////////////////////////////
// SetModified(): Sets the modified flag. Called after EN_CHANGE message sent
//                by CEdit control in CUvikonView. This hack is necessary to
//                give the doc a chance to be saved when the user exits the app
//                without a prior focus change of CEdit after the last modifications
//////////////////////////////////////////////////////////////////////////////
void CUvikonDoc::SetModified()
{
	SetModifiedFlag(TRUE);
}

//////////////////////////////////////////////////////////////////////////////
// IsFirstFix(): Helper to see whether this is the first lambda fix run with 
//               the current parameters. If FALSE, a new run is started
// Return: BOOL TRUE if it is the first run, FALSE if not
//////////////////////////////////////////////////////////////////////////////
BOOL CUvikonDoc::IsFirstFix()
{
	return m_bFirstFix;
}

//////////////////////////////////////////////////////////////////////////////
// SetFirstFix(): Sets the m_bFirstFix member
// Argument: bFirst: new value of m_bFirstFix
//////////////////////////////////////////////////////////////////////////////
void CUvikonDoc::SetFirstFix(BOOL bFirst)
{
	m_bFirstFix = bFirst;
}

////////////////////////////////////////////////////////////////////////////
// GetNumRun(): Helper to access the number of stored runs
// Return: int number of runs in this document
////////////////////////////////////////////////////////////////////////////
int CUvikonDoc::GetNumRun()
{
	return m_Data.GetSize();
}

////////////////////////////////////////////////////////////////////////////
// GetCurrentRun(): Helper to access the number of stored runs
// Return: int number of runs in this document
////////////////////////////////////////////////////////////////////////////
int CUvikonDoc::GetCurrentRun()
{
	return m_nCurrentRun;
}

////////////////////////////////////////////////////////////////////////////
// GetListView(): Gets a ptr to the listbox view
// Return: ptr to CListView attached to this document
//         NULL if no CUvikonView found
////////////////////////////////////////////////////////////////////////////
CView* CUvikonDoc::GetListView()
{
	POSITION pos = GetFirstViewPosition();
	CView* pFirstView = GetNextView(pos);
	if (!pFirstView->IsKindOf(RUNTIME_CLASS(CListView)))
	{
		pFirstView = GetNextView(pos);
		if (!pFirstView->IsKindOf(RUNTIME_CLASS(CListView)))
		{
			return NULL; // unexpected error
		}
	}
	return pFirstView;
}

////////////////////////////////////////////////////////////////////////////
// GetUvikonView(): Gets a ptr to the CEdit view
// Return: ptr to CUvikonView attached to this document
//         NULL if no CUvikonView found
////////////////////////////////////////////////////////////////////////////
CView* CUvikonDoc::GetUvikonView()
{
	POSITION pos = GetFirstViewPosition();
	CView* pFirstView = GetNextView(pos);
	if (!pFirstView->IsKindOf(RUNTIME_CLASS(CUvikonView)))
	{
		pFirstView = GetNextView(pos);
		if (!pFirstView->IsKindOf(RUNTIME_CLASS(CUvikonView)))
		{
			return NULL; // unexpected error
		}
	}
	return pFirstView;
}

////////////////////////////////////////////////////////////////////////////
// GetRunTitle(): Returns the title of the requested run
// Argument: nIndex: index of CData member to retrieve
// Return: CString* ptr to CString holding the title, NULL if nIndex invalid
////////////////////////////////////////////////////////////////////////////
CString* CUvikonDoc::GetRunTitle(int nIndex)
{
	if (nIndex >= 0 && nIndex < m_Data.GetSize())
	{
		return &(((CData*)(m_Data.GetAt(nIndex)))->m_szTitle);
	}
	else
	{
		return NULL;
	}
}

/////////////////////////////////////////////////////////////////////////////
// SetRunTitle(): Sets new title of run
// Arguments: nIndex: index of title to set
//            pszTitle: ptr to CString containing new title
//            pDC: ptr to device context
//            pTm: ptr to TEXTMETRIC struct containing metric info
/////////////////////////////////////////////////////////////////////////////
void CUvikonDoc::SetRunTitle(int nIndex, CString* pszTitle, CDC* pDC, TEXTMETRIC* pTm)
{
	CSize Extent;
	
	TRY
	{
		CData* pData = new CData;
	
		// prepare undo
		ClearUndoBuffer();
		m_PrevDocSize = m_DocSize;
		m_nUndoType = UNDO_TITLEEDIT;
		m_UndoIndex.Add((UINT)(nIndex));
		pData->m_szTitle = ((CData*)(m_Data.GetAt(nIndex)))->m_szTitle;
		m_UndoData.Add(pData);	// copy ptr to undo array
		
		m_UpdateIndex.Add(m_nCurrentRun);
	}
	CATCH(CException, e)
	{
		AfxMessageBox("Out of memory", MB_OK|MB_ICONSTOP);
		return;
	}
	END_CATCH
	
	// update title string in our data member
	((CData*)(m_Data.GetAt(nIndex)))->m_szTitle = *pszTitle;
	SetModifiedFlag(TRUE);
	
	// recalc new docsize (only grow, don't shrink)
	Extent = pDC->GetTabbedTextExtent(*pszTitle, pszTitle->GetLength(), 0, NULL);    
    Extent.cx += DOC_LEFTMARGIN + DOC_RIGHTMARGIN;
    if (Extent.cx > m_DocSize.cx)
    {
    	m_DocSize.cx = Extent.cx;
    }
	m_DocSize.cy = (m_Data.GetSize())*(pTm->tmHeight + DOC_LINESPACE);
	
	UpdateAllViews(NULL, 0L, this);
}

////////////////////////////////////////////////////////////////////////////
// GetIsSelected(): Returns whether a given item is selected
// Argument: nIndex: index of item to look up
// Return: int SEL_TRUE if item is currently selected, SEL_FALSE if not
//             SEL_CURRENT if item is current run
////////////////////////////////////////////////////////////////////////////
int CUvikonDoc::GetIsSelected(int nIndex)
{
	if (nIndex == m_nCurrentRun)
	{
		return SEL_CURRENT;
	}
	else
	{
		return (int)(((CData*)(m_Data.GetAt(nIndex)))->m_bSelected);
	}
}

/////////////////////////////////////////////////////////////////////////////
// GetDocSize(): Returns current document size. Used for scrolling
// Return: CSize current document size
/////////////////////////////////////////////////////////////////////////////
CSize CUvikonDoc::GetDocSize()
{
	return m_DocSize;
}

/////////////////////////////////////////////////////////////////////////////
// SetDocSize(): Adjusts document size after size has changed
// Arguments: pDC: ptr to device context
//            pTm: ptr to Textmetrics struct holding metric info
/////////////////////////////////////////////////////////////////////////////
void CUvikonDoc::SetDocSize(CDC* pDC, TEXTMETRIC* pTm)
{
	int i;
	CSize extent;
	CSize maxExtent(0, 0);
	CString* pszTitle;
	
	for (i = 0; i < m_Data.GetSize(); i++)       // walk thru all runs
	{
		pszTitle = &((CData*)(m_Data.GetAt(i)))->m_szTitle;
		extent = pDC->GetTabbedTextExtent(*pszTitle, pszTitle->GetLength(), 0, NULL);
		maxExtent.cx = (maxExtent.cx > extent.cx) ? maxExtent.cx:extent.cx;
	}
	
	m_DocSize.cx = maxExtent.cx + DOC_LEFTMARGIN + DOC_RIGHTMARGIN;
	m_DocSize.cy = (m_Data.GetSize())*(pTm->tmHeight + DOC_LINESPACE);

}

//////////////////////////////////////////////////////////////////////////////
// CUvikonDoc overrides

/////////////////////////////////////////////////////////////////////////
// OnSaveDocument(): Called when user selects File Save or File Save As.. command
//                   This override retrieves the last changes from CUvikonView's
//                   CEdit member if these changes were not yet updated.
/////////////////////////////////////////////////////////////////////////
BOOL CUvikonDoc::OnSaveDocument(const char* pszPathName)
{
    CEdit &EditCtrl = ((CUvikonView*)GetUvikonView())->GetEditCtrl();
    UpdateRun(EditCtrl);       // retrieve changes
    
    return CDocument::OnSaveDocument(pszPathName); // call base class handler to do the rest
}

/////////////////////////////////////////////////////////////////////////////
// CanCloseFrame(): Called when the last frame of the document is about to be 
//                  closed.
//                  This override retrieves the last changes from CUvikonView's
//                  CEdit member if these changes were not yet updated. Thus the
//                  document can be marked as changed and the base class 
//                  implementation of this fn asks for the doc to be saved.
/////////////////////////////////////////////////////////////////////////////
BOOL CUvikonDoc::CanCloseFrame(CFrameWnd* pFrame)
{
    CEdit &EditCtrl = ((CUvikonView*)GetUvikonView())->GetEditCtrl();
    UpdateRun(EditCtrl);    // retrieve changes
    
    return CDocument::CanCloseFrame(pFrame);  // call base class handler to do the rest
}

//////////////////////////////////////////////////////////////////////////////
// CUvikonDoc functions

//////////////////////////////////////////////////////////////////////////////
// SortArray(): Helper function to sort integer array in descending order
//              (primitive bubble sort)
// Arguments: int* pArray: ptr to start of array to sort
//            int numItems: number of items to sort
//////////////////////////////////////////////////////////////////////////////
void CUvikonDoc::SortArray(int* pArray, int numItems)
{
	int i, j, helper;
	
	for (i = 0; i < numItems-1; i++)
	{
		for (j = i+1; j < numItems; j++)
		{
			if (*(pArray+i) < *(pArray+j))
			{
				helper = *(pArray+i);
				*(pArray+i) = *(pArray+j);
				*(pArray+j) = helper;
			}	
		}
	}
}

/////////////////////////////////////////////////////////////////////////////
// CompactMem(): Called after WM_COMPACTING. We free extra allocated memory
//               from member arrays
/////////////////////////////////////////////////////////////////////////////
void CUvikonDoc::CompactMem()
{
	m_Data.FreeExtra();
	m_UndoData.FreeExtra();
	m_UndoIndex.FreeExtra();
}




/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CData class implementation

IMPLEMENT_SERIAL(CData, CObject, 0)

/////////////////////////////////////////////////////////////////////////////
// CData construction/destruction

CData::CData()
{
	// TODO: add one-time construction code here
	m_nMethod = MET_DEFAULT;
	m_bSelected = FALSE;
}

CData::~CData()
{
}

/////////////////////////////////////////////////////////////////////////////
// CData diagnostics

#ifdef _DEBUG
void CData::AssertValid() const
{
	CObject::AssertValid();
}

void CData::Dump(CDumpContext& dc) const
{
	CData::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CData serialization

void CData::Serialize(CArchive& ar)
{
    CObject::Serialize(ar);
    
	if (ar.IsStoring())
	{
		ar<<m_szTitle;
		ar<<m_szData;
		ar.Write(&m_nMethod, sizeof(m_nMethod));
	}
	else
	{
		ar>>m_szTitle;
		ar>>m_szData;
		ar.Read(&m_nMethod, sizeof(m_nMethod));
	}
}

