// uvikovw.h : interface of the CUvikonView class
//
/////////////////////////////////////////////////////////////////////////////

class CUvikonView : public CEditView
{
protected: // create from serialization only
	CUvikonView();
	DECLARE_DYNCREATE(CUvikonView)

// Data
protected:
	int m_nCycleNumber;       // internal counter for number of cycles to run
	int m_nImportType;        // type of import method. Identical to TheApp::m_nMethod
							  // for Run Sample. Set by user for Read Curve
	
// Attributes
public:
	CUvikonDoc* GetDocument();

// Operations
public:
	void OnRunRunbaseline();
	void OnUpdateRunRunbaseline(CCmdUI* pCmdUI);
	void OnRunRunsample();
	void OnUpdateRunRunsample(CCmdUI* pCmdUI);
	void OnRunReset();
	void OnUpdateRunReset(CCmdUI* pCmdUI);
	void OnRunReadcurve();
	void OnUpdateRunReadcurve(CCmdUI* pCmdUI);

// Implementation
public:
	virtual ~CUvikonView();
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
    int ReadCommBlock(int idDevice, CString* lpszBlock, CString* lpszError, int nMaxlen);	// reads com block after message
    void UpdateStatusString();
// Generated message map functions
protected:
	afx_msg LRESULT OnCommNotify(WPARAM wParam, LPARAM lParam/*UINT idDevice, LONG nNotifyStatus*/);
	afx_msg LRESULT OnFixChange(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnLowMem(WPARAM wParam, LPARAM lParam);
	afx_msg void OnENChange();
	//{{AFX_MSG(CUvikonView)
	afx_msg void OnEditClearAll();
	afx_msg void OnUpdateEditClearAll(CCmdUI* pCmdUI);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnEditSelectAll();
	afx_msg void OnUpdateEditSelectAll(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in uvikovw.cpp
inline CUvikonDoc* CUvikonView::GetDocument()
   { return (CUvikonDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
