// uvikovw.cpp : implementation of the CUvikonView class
//

#include "stdafx.h"
//#include "metdata.h"
#include "uvikon.h"

//#include "uvikodoc.h"
#include "uvikovw.h"
#include "readcrvd.h"
#include "mainfrm.h"
#include "samplena.h"

#include <afxwin.h>
#include <afx.h>
#include <afxext.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

// statics for floating menu
static char szFMUndo[] = "Undo";
static char szFMCut[] = "Cut";
static char szFMCopy[] = "Copy";
static char szFMPaste[] = "Paste";
static char szFMSelectAll[] = "Select all";
static char szFMDelete[] = "Delete";
static char szFMDeleteAll[] = "Delete all";

/////////////////////////////////////////////////////////////////////////////
// CUvikonView

IMPLEMENT_DYNCREATE(CUvikonView, CEditView)

BEGIN_MESSAGE_MAP(CUvikonView, CEditView)
	ON_MESSAGE(WM_COMMNOTIFY, OnCommNotify)
	ON_MESSAGE(WM_FIXCHANGE, OnFixChange)
	ON_MESSAGE(WM_LOWMEM, OnLowMem)
	ON_EN_CHANGE(AFX_IDW_PANE_FIRST, OnENChange)
	//{{AFX_MSG_MAP(CUvikonView)
	ON_COMMAND(ID_EDIT_CLEAR_ALL, OnEditClearAll)
	ON_UPDATE_COMMAND_UI(ID_EDIT_CLEAR_ALL, OnUpdateEditClearAll)
	ON_WM_SETFOCUS()
	ON_WM_KILLFOCUS()
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_EDIT_SELECT_ALL, OnEditSelectAll)
	ON_UPDATE_COMMAND_UI(ID_EDIT_SELECT_ALL, OnUpdateEditSelectAll)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUvikonView construction/destruction

CUvikonView::CUvikonView()
{
	// TODO: add construction code here
}

CUvikonView::~CUvikonView()
{
}

/////////////////////////////////////////////////////////////////////////////
// CUvikonView drawing

/////////////////////////////////////////////////////////////////////////////
// OnDraw(): called when redrawing of data is necessary
// Here, no drawing is required, we let CEditView do the rest
////////////////////////////////////////////////////////////////////////////
void CUvikonView::OnDraw(CDC* pDC)   // 
{
	//CUvikonDoc* pDoc = GetDocument();
	//ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
}

///////////////////////////////////////////////////////////////////////////////
// OnUpdate(): called when data change
// Arguments: lHint: Update editctrl if HIWORD == TRUE, do nothing if FALSE
///////////////////////////////////////////////////////////////////////////////
void CUvikonView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint)
{
	if (HIWORD(lHint))
	{
		CUvikonDoc* pDoc = GetDocument();
		CEdit &EditCtrl = GetEditCtrl();   // Get a reference to the embedded Edit control
	    CString* pString = pDoc->GetData();
	    if (pString != NULL)
	    {
	    	EditCtrl.SetWindowText(*(pDoc->GetData()));    // update contents
	    }
	    else                               // data array is empty
	    {
	    	EditCtrl.SetWindowText("");						// show a clean control
	    }
    }
    // else: the update notification does not affect the data pane
}

/////////////////////////////////////////////////////////////////////////////
// CUvikonView diagnostics

#ifdef _DEBUG
void CUvikonView::AssertValid() const
{
	CView::AssertValid();
}

void CUvikonView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CUvikonDoc* CUvikonView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CUvikonDoc)));
	return (CUvikonDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CUvikonView message handlers

/////////////////////////////////////////////////////////////////////////////
// OnFixChange(): Handler for user-defined message WM_USER + 100
//                This message is sent by CWinApp after a change in the lambda
//                fix method settings. Used to update the firstfix switch in
//                each open document
// Arguments: currently not used
// Return: always zero
/////////////////////////////////////////////////////////////////////////////
LRESULT CUvikonView::OnFixChange(WPARAM wParam, LPARAM lParam)
{
	((CUvikonDoc*)GetDocument())->SetFirstFix(TRUE);
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// OnLowMem(): Handler for user-defined message WM_USER + 101
//             This message is sent by CWinApp when memory gets low
//             We use it to tell the document to free memory
// Arguments: currently not used
// Return: always zero
/////////////////////////////////////////////////////////////////////////////
LRESULT CUvikonView::OnLowMem(WPARAM wParam, LPARAM lParam)
{
	((CUvikonDoc*)GetDocument())->CompactMem();
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// OnSetFocus(): Called after Wnd gets input focus
/////////////////////////////////////////////////////////////////////////////
void CUvikonView::OnSetFocus(CWnd* pOldWnd)
{
	CEditView::OnSetFocus(pOldWnd);
	
	UpdateStatusString();
}

////////////////////////////////////////////////////////////////////////////
// OnKillFocus(): Called when CEdit loses focus
// Arguments: pNewWnd: ptr to Wnd with input focus after CEdit
////////////////////////////////////////////////////////////////////////////
void CUvikonView::OnKillFocus(CWnd* pNewWnd)
{
	CEditView::OnKillFocus(pNewWnd);
	
	CUvikonDoc* pDoc = (CUvikonDoc*)GetDocument();
	CEdit &EditCtrl = GetEditCtrl();
	pDoc->UpdateRun(EditCtrl);
	UpdateStatusString();
}

//////////////////////////////////////////////////////////////////////////////
// OnRButtonDown(): Handler for mouse right button down message
//                  Used here to invoke a floating menu
//////////////////////////////////////////////////////////////////////////////
void CUvikonView::OnRButtonDown(UINT nFlags, CPoint point)
{
	CMenu menu;
	int nStart, nStop;
	
	menu.CreatePopupMenu();
	
	CEdit &EditCtrl = GetEditCtrl();
	
	if (EditCtrl.CanUndo())
	{
		menu.AppendMenu(MF_ENABLED|MF_STRING, ID_EDIT_UNDO, szFMUndo);
	}
	else
	{
		menu.AppendMenu(MF_GRAYED|MF_STRING, ID_EDIT_UNDO, szFMUndo);
	}
	
	menu.AppendMenu(MF_ENABLED|MF_SEPARATOR);
	
	EditCtrl.GetSel(nStart, nStop);
	if (nStart != nStop)
	{
		menu.AppendMenu(MF_ENABLED|MF_STRING, ID_EDIT_CUT, szFMCut);
	}
	else
	{
		menu.AppendMenu(MF_GRAYED|MF_STRING, ID_EDIT_CUT, szFMCut);
	}
	
	if (nStart != nStop)
	{
		menu.AppendMenu(MF_ENABLED|MF_STRING, ID_EDIT_COPY, szFMCopy);
	}
	else
	{
		menu.AppendMenu(MF_GRAYED|MF_STRING, ID_EDIT_COPY, szFMCopy);
	}
	
	if (OpenClipboard())
	{
		if (IsClipboardFormatAvailable(CF_TEXT))
		{
			menu.AppendMenu(MF_ENABLED|MF_STRING, ID_EDIT_PASTE, szFMPaste);
		}
		else
		{
			menu.AppendMenu(MF_GRAYED|MF_STRING, ID_EDIT_PASTE, szFMPaste);
		}
		CloseClipboard();
	}
	else
	{
		menu.AppendMenu(MF_GRAYED|MF_STRING, ID_EDIT_PASTE, szFMPaste);
	}
	
	menu.AppendMenu(MF_ENABLED|MF_SEPARATOR);
	
	if (GetWindowTextLength() > 0)
	{
		menu.AppendMenu(MF_ENABLED|MF_STRING, ID_EDIT_SELECT_ALL, szFMSelectAll);
	}
	else
	{
		menu.AppendMenu(MF_GRAYED|MF_STRING, ID_EDIT_SELECT_ALL, szFMSelectAll);
	}
	
	menu.AppendMenu(MF_ENABLED|MF_SEPARATOR);
	
	if (nStart != nStop)
	{
		menu.AppendMenu(MF_ENABLED|MF_STRING, ID_EDIT_CLEAR, szFMDelete);
	}
	else
	{
		menu.AppendMenu(MF_GRAYED|MF_STRING, ID_EDIT_CLEAR, szFMDelete);
	}
	
	if (GetWindowTextLength() > 0)
	{
		menu.AppendMenu(MF_ENABLED|MF_STRING, ID_EDIT_CLEAR_ALL, szFMDeleteAll);
	}
	else
	{
		menu.AppendMenu(MF_GRAYED|MF_STRING, ID_EDIT_CLEAR_ALL, szFMDeleteAll);
	}
	
    ClientToScreen(&point);     // convert point from client to screen coordinates
	                            // Invoke floating pop-up menu at cursor position
	menu.TrackPopupMenu(TPM_LEFTALIGN | TPM_LEFTBUTTON, 
							point.x, point.y, this, NULL);
	
	CEditView::OnRButtonDown(nFlags, point);
}

////////////////////////////////////////////////////////////////////////////////
// OnENChange(): Handler for EN_CHANGE message sent from CEdit after any changes
//               in the text. Used here to mark the document as modified to give
//               the doc a chance to get saved, even if the focus is not moved
//               away from CEdit (thus updating the contents in the doc) after
//               the last changes.
////////////////////////////////////////////////////////////////////////////////
void CUvikonView::OnENChange()
{
	((CUvikonDoc*)GetDocument())->SetModified();
	
	// Test
	UpdateStatusString();
}

/////////////////////////////////////////////////////////////////////////////
// OnCommNotify(): Handler for ON_COMMNOTIFY message sent by com driver
// Arguments: wParam = idDevice
//            LOWORD(lParam) = nNotifyStatus
// Return: 0
/////////////////////////////////////////////////////////////////////////////
LRESULT CUvikonView::OnCommNotify(WPARAM wParam, LPARAM lParam)
{                                 

	int nLength, nError, nSubString;
	char DecimalSeparator, ColumnSeparator;
	COMSTAT ComStat;
	MSG msg;
	CString buffer;
	CString errorString;
	CString subString;
	CString helper;
	char szError[13], szBuffer[20];
	CUvikonApp* ptrApp;
	CUvikonDoc* pDoc;
	BOOL bEndFlag;
	
	bEndFlag = FALSE;
	pDoc = (CUvikonDoc*)GetDocument();
	ptrApp = (CUvikonApp*)AfxGetApp();
	DecimalSeparator = ptrApp->GetDecimalSeparator();
	ColumnSeparator = ptrApp->GetColumnSeparator();
	CEdit &EditCtrl = GetEditCtrl();
	
	// check whether it is an event
	if (CN_EVENT & LOWORD(lParam) != CN_EVENT)
    	return 0;                                       // skip if not
    
    // clear event word so we're notified after the next event
    GetCommEventMask((int)wParam, EV_RXFLAG);
    
    do        // loop until input queue empty or other message received through PeekMessage
    {
    	if (nLength = ReadCommBlock((int)wParam, &buffer, &errorString, MAXBLOCK ))
        {
    		// Find tokens separated by returns
    		do
    		{
    			nSubString = buffer.Find(ASCII_CR) + 1;
    			if (nSubString == 0)
    			{
    				subString = buffer;
     				buffer.Empty();
   				}
    			else
    			{
	     			subString = buffer.Left(nSubString);
    				buffer = buffer.Right(buffer.GetLength() - nSubString);
    				if (m_nImportType == MET_LFIX)			// In case of Lambda fix,
    				{                                   // we're done after the first CR-string
    					bEndFlag = TRUE;
    				}
   				}
    			
	    		// Add and reset error string
	    		if (!errorString.IsEmpty())
	    		{
	    			subString += errorString;
	    			errorString.Empty();
	    		}
	    		
	    		if (m_nImportType == MET_LFIX)
	    		{
	    			// Change space for user-defined separator
	    			do
	    			{
		    			nSubString = subString.Find(' ');
		    			if (nSubString > 0)
		    			{
		    				if (subString.GetAt(nSubString-1) == ColumnSeparator)   // no consecutive separators
		    				{
			    				helper = subString.Left(nSubString);
			    				helper += subString.Right(subString.GetLength() - nSubString - 1);
			    				subString = helper;
		    				}
		    				else
		    				{
		    					subString.SetAt(nSubString, ColumnSeparator);
		    				}
		    			}
		    			else if (nSubString == 0)      // remove leading spaces
		    			{
		    				helper = subString.Right(subString.GetLength()-1);
		    				subString = helper;
		    			}
	    			}
	    			while (nSubString != -1);
	    		}
	    		else
	    		{
	    			// remove spaces
		    		do
		    		{
		    			nSubString = subString.Find(' ');
		    			if (nSubString != -1)
		    			{
		    				helper = subString.Left(nSubString);
		    				helper += subString.Right(subString.GetLength() - nSubString - 1);
		    				subString = helper;
		    			}
		    		}
		    		while (nSubString != -1);
		    		
	    			// Change "/" for user-defined separator
	    			nSubString = subString.Find('/');
	    			if (nSubString != -1)
	    			{
	    				subString.SetAt(nSubString, ColumnSeparator);
	    			}
    			}
    			// Check decimal separators
    			if (DecimalSeparator != '.')
    			{
	    			do
	    			{
	    				nSubString = subString.Find('.');
	    				if (nSubString != -1)
	    				{
	    					subString.SetAt(nSubString, DecimalSeparator);
	    				}
	    			}
	    			while (nSubString != -1);
    			}
    			
		    	// Add new string to CEdit
		        if (subString.GetLength() > 0)
		        {
		        	EditCtrl.ReplaceSel(subString);
		        	nSubString = EditCtrl.GetLine(EditCtrl.GetLineCount()-1, szBuffer, 20);
		        	if (nSubString > 0)
		        	{
			        	szBuffer[nSubString-1] = '\0';
			        	subString = szBuffer;
	    				nSubString = subString.Find("END");
		    			if (nSubString != -1)
		    			{
		    				bEndFlag = TRUE;
		    			}
	    			}
		        	
		        	// Update status line: %used
		        	UpdateStatusString();
		        }
    		}
    		while(buffer.GetLength() > 0);
        }
        
        if (nError = GetCommError((int)wParam, &ComStat ))
        {
            //if (DISPLAYERRORS( npTTYInfo ))
            //{
            	wsprintf(szError, "\t<CE-%d>\r", nError);
            	errorString += szError;
            	OnUpdate(NULL, (LPARAM)0, (CObject*)NULL);
            //}
        }
    }
    while ((!PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE )) ||
            (nLength > 0));
            
	// Release COM input if END was detected
	if (bEndFlag)
	{
		m_nCycleNumber--;
		if (m_nCycleNumber == 0)
		{
			EnableCommNotification(ptrApp->GetCOMID(), NULL, -1,-1);
			ptrApp->SetRunType(0);              // Run is finished
			pDoc->UpdateRun(EditCtrl);          // update data in document data member
		}
	}

	return 0;	
}

/////////////////////////////////////////////////////////////////////////////
// CUvikonView command handlers

///////////////////////////////////////////////////////////////////////////
// OnRunRunbaseline(): Handler for Run-Run Baseline menu command
///////////////////////////////////////////////////////////////////////////
void CUvikonView::OnRunRunbaseline()
{
	CUvikonApp* ptrApp;
	char buffer1[4] = "\x1b\x63\r";     // ESC c CR
	char buffer2[4] = "\x1b\x68\r";		// ESC h CR
	int nIDComDev, nMethod;
	ptrApp = (CUvikonApp*)AfxGetApp();
	nIDComDev = ptrApp->GetCOMID();
	
	nMethod = ptrApp->GetMethod();
	
	switch (nMethod)
	{
		case MET_DEFAULT:
			break;    // no method, do nothing
		case MET_LSCAN:
			ptrApp->WriteCommString(buffer1);
			break;
		case MET_LFIX:       // same as 3, thus no break
		case MET_TDRIVE:
			ptrApp->WriteCommString(buffer2);
			break;
	} 
}

void CUvikonView::OnUpdateRunRunbaseline(CCmdUI* pCmdUI)
{
	CUvikonApp* ptrApp;
	
	ptrApp = (CUvikonApp*)AfxGetApp();
	
	pCmdUI->Enable(ptrApp->GetRunType() == 0 && ptrApp->GetIsCollecting() &&
					ptrApp->GetMethod() != 0);	// switch off if waiting for data or no method selected	
	pCmdUI->SetCheck(ptrApp->GetRunType() == BASELINE_RUN);
}

///////////////////////////////////////////////////////////////////////////
// OnRunRunsample(): Handler for Run-Run Sample menu command
///////////////////////////////////////////////////////////////////////////
void CUvikonView::OnRunRunsample()
{
	CUvikonApp* ptrApp;
	CUvikonDoc* pDoc;
	CString szHeader, szTitle;
	int nIDComDev, nMethod, nPos;
	char buffer[4] = "\x1b\x61\r";      // ESC a CR
	char szRun[20];
	char szType[6];
	CSampleNameDlg dlg;
	TEXTMETRIC tm;
	
	ptrApp = (CUvikonApp*)AfxGetApp();
	nIDComDev = ptrApp->GetCOMID();
	pDoc = (CUvikonDoc*)GetDocument();
	
	CEdit &EditCtrl = GetEditCtrl();      // get a reference to the embedded CEdit control
	
	pDoc->UpdateRun(EditCtrl);				// save previous changes
	
	nMethod = ptrApp->GetMethod();
	
	if (nMethod != MET_LFIX ||(nMethod == MET_LFIX && pDoc->IsFirstFix()))
	{
		// Create header
		switch (nMethod)
		{
			case MET_LSCAN:
				strcpy(szType, "SCAN");
				break;
			case MET_LFIX:
				strcpy(szType, "LFIX");
				break;
			case MET_TDRIVE:
				strcpy(szType, "TDRV");
				break;
		}
		wsprintf(szRun, "%s Run %i: ", szType, pDoc->GetNumRun());
		szTitle = szRun;
		
		// If requested, add custom header
		if (ptrApp->GetHeaderSample())
		{
			dlg.m_numRun = pDoc->GetNumRun();
			if (dlg.DoModal() == IDOK)
			{
				szTitle += dlg.m_szSampleName;
			}
			else
			{
				return;
			}
		}
		
		// If requested, write methods header. Fn adds to the existing szHeader string
		if (ptrApp->GetHeaderMethod())
		{
			(ptrApp->GetMethodData())->WriteMethodsHeader(&szHeader);
		}
		
		// calculate extent of new title
		CDC* pDC = GetDC();
		CFont* pOldFont = (CFont*)pDC->SelectStockObject(SYSTEM_FONT);
		CSize Extent = pDC->GetTabbedTextExtent(szTitle, szTitle.GetLength(), 0, NULL);
		pDC->GetTextMetrics(&tm);
		pDC->SelectObject(pOldFont);
		ReleaseDC(pDC);
		if (!pDoc->StartNewRun(&szTitle, nMethod, Extent.cx, &tm))
		{
			AfxMessageBox("Could not start new run", MB_OK|MB_ICONSTOP);
			return;
		}
		pDoc->SetFirstFix(FALSE);
		EditCtrl.SetSel(0, -1, FALSE);	// select all, will be overwritten by ReplaceSel
	}
	else if (nMethod == MET_LFIX)       // if we add more data to the same LFIX run
	{
		nPos = EditCtrl.GetWindowTextLength();
		EditCtrl.SetSel(nPos, nPos, FALSE);
	}
	
	if (nMethod != MET_LFIX)
	{
		pDoc->SetFirstFix(TRUE);
	}
	
	// If requested, write time and date
	if (ptrApp->GetHeaderTime())
	{
		CTime tTime = CTime::GetCurrentTime();
		szHeader += tTime.Format("%m/%d/%Y %H:%M:%S\r\n");
	}
	
	EditCtrl.ReplaceSel(szHeader);  // and replace by new header
	
	// Get number of cycles
	m_nCycleNumber = (ptrApp->GetMethodData())->nCycleNumber;
	
	// Capture COM input to the active view
	EnableCommNotification(nIDComDev, m_hWnd, -1, -1);
    // assert DTR
    EscapeCommFunction(nIDComDev, SETDTR);
    
	ptrApp->SetRunType(SAMPLE_RUN);
	m_nImportType = nMethod;
	
	ptrApp->WriteCommString(buffer);
}

void CUvikonView::OnUpdateRunRunsample(CCmdUI* pCmdUI)
{
	CUvikonApp* ptrApp;
	
	ptrApp = (CUvikonApp*)AfxGetApp();
	
	pCmdUI->Enable(ptrApp->GetRunType() == 0 && ptrApp->GetIsCollecting() &&
								ptrApp->GetMethod() != 0);	// switch off if waiting for data or no method selected
	pCmdUI->SetCheck(ptrApp->GetRunType() == SAMPLE_RUN);
}


///////////////////////////////////////////////////////////////////////////
// OnRunReadcurve(): Handler for Run-Read Curve menu command
///////////////////////////////////////////////////////////////////////////
void CUvikonView::OnRunReadcurve()
{
	BOOL bContinue;
	CUvikonApp* ptrApp;
	int nMethod, nOutcome, nIDComDev, nLineNumber;
	CReadcrvDlg dlg;
	char szSendString[20];
	CUvikonDoc* pDoc;
	CString szHeader, szTitle;
	char szRun[20];
	char szType[6];
	CSampleNameDlg dlgn;
	TEXTMETRIC tm;
	
	ptrApp = (CUvikonApp*)AfxGetApp();
	nIDComDev = ptrApp->GetCOMID();
	pDoc = (CUvikonDoc*)GetDocument();
	nLineNumber = 1;
	
	CEdit &EditCtrl = GetEditCtrl();      // get a reference to the embedded CEdit control
	nMethod = ptrApp->GetMethod();
	
	
	// switch to curve memory page
	if (nMethod == MET_LFIX)              // lambda fix
	{
		// first go back to methods page
		sprintf(szSendString, "\x1B\x67\r");  // ESC g CR
		ptrApp->WriteCommString(szSendString);
	}
	
	sprintf(szSendString, "\x1B\x65\r");  // ESC e CR
	ptrApp->WriteCommString(szSendString);
	dlg.m_nMethod = (nMethod == MET_TDRIVE) ? 1 : 0;
	
	do
	{
		dlg.nLineNumber = nLineNumber;
		nOutcome = dlg.DoModal();
		if (nOutcome == IDOK)
		{
			bContinue = FALSE;
		}
		else if (nOutcome == READCURVE)
		{
			bContinue = TRUE;
			nLineNumber = dlg.nLineNumber;
			
			pDoc->UpdateRun(EditCtrl);				// save previous changes
	
			m_nImportType = (dlg.m_nMethod == 0) ? MET_LSCAN : MET_TDRIVE;
	
			// Create header
			switch (m_nImportType)
			{
				case MET_LSCAN:
					strcpy(szType, "SCAN");
					break;
				case MET_TDRIVE:
					strcpy(szType, "TDRV");
					break;
			}
			wsprintf(szRun, "%s Run %i: ", szType, pDoc->GetNumRun());
			szTitle = szRun;
		
			// If requested, add custom header
			if (ptrApp->GetHeaderSample())
			{
				dlgn.m_numRun = pDoc->GetNumRun();
				if (dlgn.DoModal() == IDOK)
				{
					szTitle += dlgn.m_szSampleName;
				}
				else
				{
					break;
				}
			}
		
			// calculate extent of new title
			CDC* pDC = GetDC();
			CFont* pOldFont = (CFont*)pDC->SelectStockObject(SYSTEM_FONT);
			CSize Extent = pDC->GetTabbedTextExtent(szTitle, szTitle.GetLength(), 0, NULL);
			pDC->GetTextMetrics(&tm);
			pDC->SelectObject(pOldFont);
			pDoc->StartNewRun(&szTitle, nMethod, Extent.cx, &tm);
			ReleaseDC(pDC);
			pDoc->SetFirstFix(FALSE);
			EditCtrl.SetSel(0, -1, FALSE);	// select all, will be overwritten by ReplaceSel
			
			pDoc->SetFirstFix(TRUE);
			
			// If requested, write time and date
			if (ptrApp->GetHeaderTime())
			{
				CTime tTime = CTime::GetCurrentTime();
				szHeader = tTime.Format("%m/%d/%Y %H:%M:%S\r\n");
			}
			
			EditCtrl.ReplaceSel(szHeader);  // and replace by new header
			
			// Capture COM input to the active view
			EnableCommNotification(nIDComDev, m_hWnd, -1, -1);
		    // assert DTR
		    EscapeCommFunction(nIDComDev, SETDTR);
			
			sprintf(szSendString, "\x1B\x63\r");  // ESC c CR
			ptrApp->WriteCommString(szSendString);
		}
	}
	while(bContinue);
	
	// Get back to where we came from
	sprintf(szSendString, "\x1B\x66\r");  // ESC f CR
	ptrApp->WriteCommString(szSendString);
}

void CUvikonView::OnUpdateRunReadcurve(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(((CUvikonApp*)AfxGetApp())->GetIsCollecting());	// switch on if connected	
}

///////////////////////////////////////////////////////////////////////////
// OnRunReset(): Handler for Run-Reset menu command
///////////////////////////////////////////////////////////////////////////
void CUvikonView::OnRunReset()
{
	CUvikonApp* ptrApp;
	CUvikonDoc* pDoc;
	int nIDComDev;
	
	ptrApp = (CUvikonApp*)AfxGetApp();
	nIDComDev = ptrApp->GetCOMID();
	pDoc = (CUvikonDoc*)GetDocument();
	
	// Disable comm notification
	EnableCommNotification(ptrApp->GetCOMID(), NULL, -1,-1);
	ptrApp->SetRunType(0);
	
	// Transfer Data to document
	CEdit &EditCtrl = GetEditCtrl();
	pDoc->UpdateRun(EditCtrl);

	FlushComm(nIDComDev, 0); // Flush transmission queue
	FlushComm(nIDComDev, 1); // Flush receiving queue
	
	// assert DTR
	EscapeCommFunction(nIDComDev, SETDTR);
}

void CUvikonView::OnUpdateRunReset(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(((CUvikonApp*)AfxGetApp())->GetIsCollecting());	// switch on if connected
}

///////////////////////////////////////////////////////////////////////////
// OnEditClearAll(): Handler for edit-clear all menu command
///////////////////////////////////////////////////////////////////////////
void CUvikonView::OnEditClearAll()
{
	CEdit &EditCtrl = GetEditCtrl();   // Get a reference to the embedded Edit control
	EditCtrl.SetSel(0, -1, FALSE);     // select all
	EditCtrl.Clear();                  // delete selection
}

void CUvikonView::OnUpdateEditClearAll(CCmdUI* pCmdUI)
{
	CEdit &EditCtrl = GetEditCtrl();
	pCmdUI->Enable(EditCtrl.GetWindowTextLength() > 0);  // useful only when text present
}

///////////////////////////////////////////////////////////////
// OnEditSelectAll(): Handler for edit-select all menu command
///////////////////////////////////////////////////////////////
void CUvikonView::OnEditSelectAll()
{
	CEdit &EditCtrl = GetEditCtrl();   // Get a reference to the embedded Edit control
	EditCtrl.SetSel(0, -1, FALSE);     // select all
}

void CUvikonView::OnUpdateEditSelectAll(CCmdUI* pCmdUI)
{
	CEdit &EditCtrl = GetEditCtrl();
	pCmdUI->Enable(EditCtrl.GetWindowTextLength() > 0);  // useful only when text present
}

///////////////////////////////////////////////////////////////////////////////
// CUvikonView functions

/////////////////////////////////////////////////////////////////////////
// ReadCommBlock(): Reads data from COM queue
// Arguments: lpszBlock: ptr to string that receives the data
//            nMaxlen: maximum string length allowed
// Returns: number of bytes read
//          FALSE if failed
///////////////////////////////////////////////////////////////////////////
int CUvikonView::ReadCommBlock(int idDevice, CString* lpszInbox, CString* lpszError, int nMaxlen)
{
	int nLength, nError, nstringLength;
	char szError[13];
	char szInbox[MAXBLOCK+1];
	
   	nLength = ReadComm(idDevice, szInbox, nMaxlen);
   	nstringLength = abs(nLength);     // nLength is negative if there was an error
   	szInbox[nstringLength] = '\0';	  // convert to a zero-terminated string
    *lpszInbox = szInbox;             // copy string to CString object
    
   	if (nLength < 0)                  // if an error occurred
   	{
      	nLength *= -1 ;
      	while (nError = GetCommError(idDevice, NULL ))
      	{
            wsprintf(szError, "\t<CE-%d>\r", nError);
            *lpszError += szError;                  // concatenate error string
            OnUpdate(NULL, (LPARAM)0, (CObject*)NULL);
      	}
   	}
	
	return nLength;
}

///////////////////////////////////////////////////////////////////////
// UpdateStatusString(): Calculates percent edit control usage and
//                     prints result into a string
// Argument: buffer: string to hold result
///////////////////////////////////////////////////////////////////////
void CUvikonView::UpdateStatusString()
{
	UINT nTextLength;
	float percent;
	char buffer[20];
	
	CEdit &EditCtrl = GetEditCtrl();
	nTextLength = EditCtrl.GetWindowTextLength();
	percent = (float)nTextLength/32768*100;
	
	if (percent < 90)
		sprintf(buffer, "%.1f %%", percent);
	else
		sprintf(buffer, "!!! %.1f %% !!!", percent);
	
	((CMainFrame*)((CUvikonApp*)AfxGetApp())->m_pMainWnd)->UpdateStatusLine(1, buffer);
}


