// uvikon.h : main header file for the UVIKON application
//

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       // main symbols
#include "uvikodoc.h"
#include "metdata.h"
#include "splashwn.h"
/////////////////////////////////////////////////////////////////////////////
// CUvikonApp:
// See uvikon.cpp for the implementation of this class
//

class CUvikonApp : public CWinApp
{
public:
	CUvikonApp();
// Member data
private:
	BOOL m_bIsCollecting;  // TRUE if waiting for data, FALSE if offline
	int m_nRunType;			// SAMPLE_RUN if sample, BASELINE_RUN if baseline run, 0 if idle	
	int m_nMethodRadio;    // Currently selected method
	int m_nRadioBaudRate;  // Radio button setting for Baud rate
	int m_nRadioParity;    // Radio button setting for Parity check
	int m_nRadioStopBits;  // Radio button setting for Stop bits
	int m_nRadioDataBits;  // Radio button setting for Data bits
	int m_nRadioPort;      // Radio button setting for COM Port
	
    int m_nIDComDev;       // Denotes open COM device
    char m_szPortName[5];  // Port name, e.g. "COM1"

	char m_szsDecimal[2];  // Holds Windows default decimal separator
	char m_szsDecimalPrivate[2]; // Holds Uvikon decimal separator
	char m_szsColumn[2];	// Holds column separator
	int m_nDecimal;		   // combobox setting for decimal separator selection
	int m_nColumn;		   // combobox setting for column separator selection
	BOOL m_bHeaderMethod;  // checkbox setting for include method header
	BOOL m_bHeaderTime;    // checkbox setting for include sample time
	BOOL m_bHeaderSample;	// checkbox setting for include sample name
	
	CScanData m_ScanData;   // Method settings for lambda scan
	CFixData m_FixData;		// Method settings for lambda fix
	CDriveData m_DriveData;	// Method settings for time drive
	 			
	DWORD m_dwSplashTime;   // Time when splash window was created
	CSplashWnd m_splash;    // The dialog member for the splash window
	
public:
// Overrides
	virtual BOOL InitInstance();

// Functions
public:
	BOOL CloseComPort();
    int GetCOMID();
    BOOL GetIsCollecting();
    int GetRunType();
	void SetRunType(int nRunType);
	void ReadWinIni();
	char GetDecimalSeparator();
	char GetColumnSeparator();
	BOOL WriteCommString(char* string);
	int GetMethod();
	CMethodData* GetMethodData();
	BOOL GetHeaderMethod();
	BOOL GetHeaderTime();
	BOOL GetHeaderSample();
	
private:
	BOOL InitializeComPort();
	char* MakeComString();
	virtual int ExitInstance();
	BYTE GetDataBits();
	WORD GetBaudRate();
	BYTE GetParity(BOOL dcb);
	BYTE GetStopBits(BOOL dcb);
	void ReadUvikonSettings();
	void WriteUvikonSettings();
	virtual BOOL OnIdle(LONG lCount);

// Implementation

	//{{AFX_MSG(CUvikonApp)
	afx_msg void OnAppAbout();
	afx_msg void OnFileConnect();
	afx_msg void OnUpdateFileConnect(CCmdUI* pCmdUI);
	afx_msg void OnFileDisconnect();
	afx_msg void OnUpdateFileDisconnect(CCmdUI* pCmdUI);
	afx_msg void OnMethodsDefault();
	afx_msg void OnUpdateMethodsDefault(CCmdUI* pCmdUI);
	afx_msg void OnMethodsLambdafix();
	afx_msg void OnUpdateMethodsLambdafix(CCmdUI* pCmdUI);
	afx_msg void OnMethodsLambdascan();
	afx_msg void OnUpdateMethodsLambdascan(CCmdUI* pCmdUI);
	afx_msg void OnOptionsOutput();
	afx_msg void OnOptionsPort();
	afx_msg void OnUpdateOptionsPort(CCmdUI* pCmdUI);
	afx_msg void OnUpdateOptionsOutput(CCmdUI* pCmdUI);
	afx_msg void OnMethodsTimedrive();
	afx_msg void OnUpdateMethodsTimedrive(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


#define MAXBLOCK 1024
#define MAXOUTBLOCK 128
#define RXQUEUE 4096
#define TXQUEUE 4096

#define ASCII_ESC 0x1B
#define ASCII_CR 0x0D
#define ASCII_LF 0x0A

#define SAMPLE_RUN 1
#define BASELINE_RUN 2
#define MET_DEFAULT 0
#define MET_LSCAN 1
#define MET_LFIX 2
#define MET_TDRIVE 3

#define UNDO_NOTAVAIL 0
#define UNDO_CLEAR 1
#define UNDO_ADD 2
#define UNDO_TITLEEDIT 3

#define MAXINT 32767

#define SEL_FALSE 0
#define SEL_TRUE 1
#define SEL_CURRENT 2

#define DOC_LINESPACE 4
#define DOC_LEFTMARGIN 5
#define DOC_RIGHTMARGIN 5
#define DOC_ICONWIDTH 16
#define DOC_ICONHEIGHT 16
#define DOC_ICONSPACE 4

#define WM_FIXCHANGE (WM_USER + 100)
#define WM_LOWMEM (WM_USER + 101)

/////////////////////////////////////////////////////////////////////////////
