// uvikon.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "uvikon.h"

#include "mainfrm.h"
//#include "uvikodoc.h"
#include "uvikovw.h"
#include "comsets.h"
#include "lscandlg.h"
#include "outptdlg.h"
#include "lfixdlg.h"
#include "tdrivdlg.h"
#include "comfns.h"
#include "splitwnd.h"
#include "listview.h"

#include <stdio.h>
#include <string.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

////////////////////////////////////////////////////////////////////////////
// ini statics
static char iniSection2[] = "COMSettings";
static char iniBaud[] = "Baud";
static char iniParity[] = "Parity";
static char iniStop[] = "Stopbits";
static char iniData[] = "Databits";
static char iniPort[] = "Port";
static char iniSection3[] = "Output";
static char iniDecimal[] = "sDecimal";
static char iniDecSet[] = "DecSet";
static char iniColSet[] = "ColSet";
static char iniHeaderMet[] = "HeaderMet";
static char iniHeaderTime[] = "HeaderTime";
static char iniHeaderSample[] = "HeaderSample";

/////////////////////////////////////////////////////////////////////////////
// CUvikonApp

BEGIN_MESSAGE_MAP(CUvikonApp, CWinApp)
	//{{AFX_MSG_MAP(CUvikonApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_FILE_CONNECT, OnFileConnect)
	ON_UPDATE_COMMAND_UI(ID_FILE_CONNECT, OnUpdateFileConnect)
	ON_COMMAND(ID_FILE_DISCONNECT, OnFileDisconnect)
	ON_UPDATE_COMMAND_UI(ID_FILE_DISCONNECT, OnUpdateFileDisconnect)
	ON_COMMAND(ID_METHODS_DEFAULT, OnMethodsDefault)
	ON_UPDATE_COMMAND_UI(ID_METHODS_DEFAULT, OnUpdateMethodsDefault)
	ON_COMMAND(ID_METHODS_LAMBDAFIX, OnMethodsLambdafix)
	ON_UPDATE_COMMAND_UI(ID_METHODS_LAMBDAFIX, OnUpdateMethodsLambdafix)
	ON_COMMAND(ID_METHODS_LAMBDASCAN, OnMethodsLambdascan)
	ON_UPDATE_COMMAND_UI(ID_METHODS_LAMBDASCAN, OnUpdateMethodsLambdascan)
	ON_COMMAND(ID_OPTIONS_OUTPUT, OnOptionsOutput)
	ON_COMMAND(ID_OPTIONS_PORT, OnOptionsPort)
	ON_UPDATE_COMMAND_UI(ID_OPTIONS_PORT, OnUpdateOptionsPort)
	ON_UPDATE_COMMAND_UI(ID_OPTIONS_OUTPUT, OnUpdateOptionsOutput)
	ON_COMMAND(ID_METHODS_TIMEDRIVE, OnMethodsTimedrive)
	ON_UPDATE_COMMAND_UI(ID_METHODS_TIMEDRIVE, OnUpdateMethodsTimedrive)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUvikonApp construction

CUvikonApp::CUvikonApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CUvikonApp object

CUvikonApp NEAR theApp;

/////////////////////////////////////////////////////////////////////////////
// CUvikonApp initialization

BOOL CUvikonApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	SetDialogBkColor();        // Set dialog background color to gray
	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CMultiDocTemplate* pDocTemplate;
	pDocTemplate = new CMultiDocTemplate(
		IDR_UVIKONTYPE,
		RUNTIME_CLASS(CUvikonDoc),
		RUNTIME_CLASS(CSplitWnd),        // standard MDI child frame
		RUNTIME_CLASS(CUvikonView));
	AddDocTemplate(pDocTemplate);

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// The main window has been initialized, so show and update it.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();
	
	// Now we prepare the splash window
	if (!m_pMainWnd->IsIconic() && m_splash.Create(m_pMainWnd))
	{
		m_splash.ShowWindow(SW_SHOW);
		m_splash.UpdateWindow();
	}
	m_dwSplashTime = ::GetCurrentTime();

	// initialize member variables
	m_bIsCollecting = FALSE;
	m_nRunType = 0;
	m_nMethodRadio = MET_DEFAULT;
	
	ReadUvikonSettings();  // from our ini file
	
	// initialize method data
	m_ScanData.SetDefault();
	m_FixData.SetDefault();
	m_DriveData.SetDefault();
	
	ReadWinIni();          // read the intl settings
	
	// create a new (empty) document
	OnFileNew();

	if (m_lpCmdLine[0] != '\0')
	{
		// TODO: add command line processing here
	}

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////////
// OnIdle(): Override of the idle loop. Destroys the splash window after some time
//////////////////////////////////////////////////////////////////////////////////////
BOOL CUvikonApp::OnIdle(LONG lCount)
{
	// call base class idle first
	BOOL bResult = CWinApp::OnIdle(lCount);

	// then do our work
	if (m_splash.m_hWnd != NULL)
	{
		if (::GetCurrentTime() - m_dwSplashTime > 6000)
		{
			// timeout expired, destroy the splash window
			m_splash.DestroyWindow();
			m_pMainWnd->UpdateWindow();

			// NOTE: don't set bResult to FALSE,
			//  CWinApp::OnIdle may have returned TRUE
		}
		else
		{
			// check again later...
			bResult = TRUE;
		}
	}

	return bResult;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CUvikonApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}


BOOL CAboutDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	::CenterWindow(GetParent(), this);    // center dialog in frame window
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}
/////////////////////////////////////////////////////////////////////////////
// CUvikonApp commands
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Event handlers


/////////////////////////////////////////////////////////////////////////////
// OnFileConnect(): Handler for the File-Connect menu command
/////////////////////////////////////////////////////////////////////////////
void CUvikonApp::OnFileConnect()
{
	if (m_bIsCollecting)           // Jump out if we're already online
	{
		return;
	}
	if (InitializeComPort() == TRUE)
	{
		m_bIsCollecting = TRUE;	    // toggle on status variable
		//((CMainFrame*)m_pMainWnd)->SetWindowText("Uvikon - Online");
	}
	else
	{
		CloseComPort();
	}
}

void CUvikonApp::OnUpdateFileConnect(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck(m_bIsCollecting);	// switch off if waiting for data	
}


//////////////////////////////////////////////////////////////////////////////
// OnFileDisconnect(): Handler for the File-Disconnect menu command
/////////////////////////////////////////////////////////////////////////////
void CUvikonApp::OnFileDisconnect()
{
	if (!m_bIsCollecting)          // jump out if we're already offline
	{
		return;
	}
	CloseComPort();
	m_bIsCollecting = FALSE;
	m_nRunType = 0;
	//((CMainFrame*)m_pMainWnd)->SetWindowText("Uvikon - Offline");		
}

void CUvikonApp::OnUpdateFileDisconnect(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck(!m_bIsCollecting);	// switch off if waiting for data	
}

/////////////////////////////////////////////////////////////////////////////////
// OnMethodsDefault(): Handler for the Methods-Default menu command
/////////////////////////////////////////////////////////////////////////////
void CUvikonApp::OnMethodsDefault()
{
	char szSendString[13];
	
	m_nMethodRadio = MET_DEFAULT;
	
	FlushComm(m_nIDComDev, 0); // Flush transmission queue
	FlushComm(m_nIDComDev, 1); // Flush receiving queue
	
	// go back to the Methods page, then select method
	sprintf(szSendString, "\x1B\x67\r");  // ESC g CR
	WriteCommString(szSendString);
}

void CUvikonApp::OnUpdateMethodsDefault(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck(m_nMethodRadio == MET_DEFAULT);	// switch on if this is the current method	
	pCmdUI->Enable(m_bIsCollecting);	    // switch on if we're connected
}

/////////////////////////////////////////////////////////////////////////////////
// OnMethodsLambdafix(): Handler for the Methods-Lambdafix menu command
/////////////////////////////////////////////////////////////////////////////
void CUvikonApp::OnMethodsLambdafix()
{
	CLFixDlg dlg;
	BOOL bChangeList[14];
	char szSendString[20];
	int i;
	
	dlg.m_nLampBandwidth = m_FixData.nLampBandwidth;
	dlg.m_bDoubleBeam = m_FixData.bDoubleBeam;
	dlg.m_fConcFactor = m_FixData.fConcFactor;
	dlg.m_nCycleNumber = m_FixData.nCycleNumber;
	dlg.m_fCycleTime = m_FixData.fCycleTime;
	dlg.m_bDLamp = m_FixData.bDLamp;
	dlg.m_bHLamp = m_FixData.bHLamp;
	dlg.m_nIntegrationTime = m_FixData.nIntegrationTime;
	dlg.m_nLampChange = m_FixData.nLampChange;
	dlg.m_nAbsMode = m_FixData.nAbsMode;
	dlg.m_bPlotMode = m_FixData.bPlotMode;
	dlg.m_fStandardConc = m_FixData.fStandardConc;
	dlg.m_nUnit = m_FixData.nUnit;
	dlg.m_nWavelength = m_FixData.nWavelength;
	
	if (dlg.DoModal() == IDOK)
	{
		m_nMethodRadio = MET_LFIX;
		
		if (dlg.m_bSendAll)
		{
			for (i = 0; i < 14; i++)           // set changeList to default
			{
				bChangeList[i] = TRUE;
			} 
		}
		else
		{
			for (i = 0; i < 14; i++)           // set changeList to default
			{
				bChangeList[i] = FALSE;
			} 
	
			// find out what has changed and copy the new values
			if (m_FixData.nAbsMode != dlg.m_nAbsMode)
			{
				bChangeList[0] = TRUE;
				m_FixData.nAbsMode = dlg.m_nAbsMode;
			}
			if (m_FixData.nWavelength != dlg.m_nWavelength)
			{
				bChangeList[1] = TRUE;
				m_FixData.nWavelength = dlg.m_nWavelength;
			}
			if (m_FixData.nIntegrationTime != dlg.m_nIntegrationTime)
			{
				bChangeList[2] = TRUE;
				m_FixData.nIntegrationTime = dlg.m_nIntegrationTime;
			}
			if (m_FixData.nCycleNumber != dlg.m_nCycleNumber)
			{
				bChangeList[3] = TRUE;
				m_FixData.nCycleNumber = dlg.m_nCycleNumber;
			}
			if (m_FixData.fCycleTime != dlg.m_fCycleTime)
			{
				bChangeList[4] = TRUE;
				m_FixData.fCycleTime = dlg.m_fCycleTime;
			}
			if (m_FixData.nLampBandwidth != dlg.m_nLampBandwidth)
			{
				bChangeList[5] = TRUE;
				m_FixData.nLampBandwidth = dlg.m_nLampBandwidth;
			}
			if (m_FixData.nLampChange != dlg.m_nLampChange)
			{
				bChangeList[6] = TRUE;
				m_FixData.nLampChange = dlg.m_nLampChange;
			}
			if (m_FixData.bHLamp != dlg.m_bHLamp)
			{
				bChangeList[7] = TRUE;
				m_FixData.bHLamp = dlg.m_bHLamp;
			}
			if (m_FixData.bDLamp != dlg.m_bDLamp)
			{
				bChangeList[8] = TRUE;
				m_FixData.bDLamp = dlg.m_bDLamp;
			}
			if (m_FixData.bDoubleBeam != dlg.m_bDoubleBeam)
			{
				bChangeList[9] = TRUE;
				m_FixData.bDoubleBeam = dlg.m_bDoubleBeam;
			}
			if (m_FixData.bPlotMode != dlg.m_bPlotMode)
			{
				bChangeList[10] = TRUE;
				m_FixData.bPlotMode = dlg.m_bPlotMode;
			}
			if (m_FixData.nUnit != dlg.m_nUnit)
			{
				bChangeList[11] = TRUE;
				m_FixData.nUnit = dlg.m_nUnit;
			}
			if (m_FixData.fConcFactor != dlg.m_fConcFactor)
			{
				bChangeList[12] = TRUE;
				m_FixData.fConcFactor = dlg.m_fConcFactor;
			}
			if (m_FixData.fStandardConc != dlg.m_fStandardConc)
			{
				bChangeList[13] = TRUE;
				m_FixData.fStandardConc = dlg.m_fStandardConc;
			}
		}
		
		// go back to the Methods page, then select method
		sprintf(szSendString, "\x1B\x67\r");  // ESC g CR
		WriteCommString(szSendString);
		sprintf(szSendString, "\x1B\x33/1\r");  // ESC 3/1 CR
		WriteCommString(szSendString);
		
		// now actually send the changed values
		// to maximize speeed, we send the strings according to the appearance on screen
		if (bChangeList[0])
		{
			sprintf(szSendString, "\x1B\x31/%u\r", m_FixData.nAbsMode + 1);  // ESC 1/1 CR through ESC 1/3 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[1])
		{
			sprintf(szSendString, "\x1B\x32/1/%u\r", m_FixData.nWavelength);  // ESC 2/1/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[2])
		{
			sprintf(szSendString, "\x1B\x33/1/%u\r", m_FixData.nIntegrationTime);  // ESC 3/1/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[3])
		{
			sprintf(szSendString, "\x1B\x34/1/%u\r", m_FixData.nCycleNumber);  // ESC 4/1/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[4])
		{
			sprintf(szSendString, "\x1B\x35/1/%.1f\r", m_FixData.fCycleTime);  // ESC 5/1/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[5])
		{
			sprintf(szSendString, "\x1B\x37/%u\r", m_FixData.nLampBandwidth + 1);  // ESC 7/1 CR through ESC 7/4 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[6])
		{
			sprintf(szSendString, "\x1B\x38/1/%u\r", m_FixData.nLampChange);  // ESC 8/1/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[7])
		{
			if (m_FixData.bHLamp == TRUE)
				sprintf(szSendString, "\x1B\x39/1\r");  // ESC 9/1 CR
			else
				sprintf(szSendString, "\x1B\x39/1\r");  // ESC 9/2 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[8])
		{
			if (m_FixData.bDLamp == TRUE)
				sprintf(szSendString, "\x1B\x31\x30/1\r");  // ESC 10/1 CR
			else
				sprintf(szSendString, "\x1B\x31\x30/2\r");  // ESC 10/2 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[9])
		{
			if (m_FixData.bDoubleBeam == TRUE)
				sprintf(szSendString, "\x1B\x31\x31/1\r");  // ESC 11/1 CR
			else
				sprintf(szSendString, "\x1B\x31\x31/2\r");  // ESC 11/2 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[10])
		{
			if (m_FixData.bPlotMode == TRUE)
				sprintf(szSendString, "\x1B\x31\x31/1\r");  // ESC 13/1 CR
			else
				sprintf(szSendString, "\x1B\x31\x31/2\r");  // ESC 13/2 CR
			WriteCommString(szSendString);
		}
		
		// always set Data to RS232 to yes
		sprintf(szSendString, "\x1B\x31\x35/1\r");  // ESC 15/1 CR
		WriteCommString(szSendString);
		
		if (bChangeList[11])
		{
			sprintf(szSendString, "\x1B\x31\x37/%u\r", m_FixData.nUnit + 1);  // ESC 17/1 CR through ESC 17/7 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[12])
		{
			sprintf(szSendString, "\x1B\x31\x38/1/%.3f\r", m_FixData.fConcFactor);  // ESC 18/1/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[13])
		{
			sprintf(szSendString, "\x1B\x31\x39/1/%.3f\r", m_FixData.fStandardConc);  // ESC 19/1/X CR
			WriteCommString(szSendString);
		}
		
		// inform all documents (via their CUvikonViews) about the change
		m_pMainWnd->SendMessageToDescendants(WM_FIXCHANGE, 0, 0, TRUE, FALSE);
	}
}

void CUvikonApp::OnUpdateMethodsLambdafix(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck(m_nMethodRadio == MET_LFIX);	// set check if this is the current method	
	pCmdUI->Enable(m_bIsCollecting);	    // switch on if we're connected
}

/////////////////////////////////////////////////////////////////////////////////
// OnMethodsTimedrive(): Handler for the Methods-Lambdaprogram menu command
/////////////////////////////////////////////////////////////////////////////
void CUvikonApp::OnMethodsTimedrive()
{
	CTDrivDlg dlg;
	BOOL bChangeList[17];
	char szSendString[20];
	int i;
	
	dlg.m_bDoubleBeam = m_DriveData.bDoubleBeam;
	dlg.m_nCycleNumber = m_DriveData.nCycleNumber;
	dlg.m_fCycleTime = m_DriveData.fCycleTime;
	dlg.m_bDLamp = m_DriveData.bDLamp;
	dlg.m_bHLamp = m_DriveData.bHLamp;
	dlg.m_nLampChange = m_DriveData.nLampChange;
	dlg.m_nAbsMode = m_DriveData.nAbsMode;
	dlg.m_nPlotMode = m_DriveData.nPlotMode;
	dlg.m_nPlotSize = m_DriveData.nPlotSize;
	dlg.m_nPlotX = m_DriveData.nPlotX;
	dlg.m_nPlotY = m_DriveData.nPlotY;
	dlg.m_fYAxisMax = m_DriveData.fYAxisMax;
	dlg.m_fYAxisMin = m_DriveData.fYAxisMin;
	dlg.m_nLampBandwidth = m_DriveData.nLampBandwidth;
	dlg.m_nSamplingRate = m_DriveData.nSamplingRate;
	dlg.m_nWavelength = m_DriveData.nWavelength;
	dlg.m_fMeasureTime = m_DriveData.fMeasureTime;
	
	if (dlg.DoModal() == IDOK)
	{
		m_nMethodRadio = MET_TDRIVE;
		
		if (dlg.m_bSendAll)
		{
			for (i = 0; i < 17; i++)           // set changeList to default
			{
				bChangeList[i] = TRUE;
			} 
		}
		else
		{
			for (i = 0; i < 17; i++)           // set changeList to default
			{
				bChangeList[i] = FALSE;
			} 
	
			// find out what has changed and copy the new values
			if (m_DriveData.nAbsMode != dlg.m_nAbsMode)
			{
				bChangeList[0] = TRUE;
				m_DriveData.nAbsMode = dlg.m_nAbsMode;
			}
			if (m_DriveData.nWavelength != dlg.m_nWavelength)
			{
				bChangeList[1] = TRUE;
				m_DriveData.nWavelength = dlg.m_nWavelength;
			}
			if (m_DriveData.fYAxisMax != dlg.m_fYAxisMax)
			{
				bChangeList[2] = TRUE;
				m_DriveData.fYAxisMax = dlg.m_fYAxisMax;
			}
			if (m_DriveData.fYAxisMin != dlg.m_fYAxisMin)
			{
				bChangeList[3] = TRUE;
				m_DriveData.fYAxisMin = dlg.m_fYAxisMin;
			}
			if (m_DriveData.nSamplingRate != dlg.m_nSamplingRate)
			{
				bChangeList[4] = TRUE;
				m_DriveData.nSamplingRate = dlg.m_nSamplingRate;
			}
			if (m_DriveData.fMeasureTime != dlg.m_fMeasureTime)
			{
				bChangeList[5] = TRUE;
				m_DriveData.fMeasureTime = dlg.m_fMeasureTime;
			}
			if (m_DriveData.nCycleNumber != dlg.m_nCycleNumber)
			{
				bChangeList[6] = TRUE;
				m_DriveData.nCycleNumber = dlg.m_nCycleNumber;
			}
			if (m_DriveData.fCycleTime != dlg.m_fCycleTime)
			{
				bChangeList[7] = TRUE;
				m_DriveData.fCycleTime = dlg.m_fCycleTime;
			}
			if (m_DriveData.nLampBandwidth != dlg.m_nLampBandwidth)
			{
				bChangeList[8] = TRUE;
				m_DriveData.nLampBandwidth = dlg.m_nLampBandwidth;
			}
			if (m_DriveData.nLampChange != dlg.m_nLampChange)
			{
				bChangeList[9] = TRUE;
				m_DriveData.nLampChange = dlg.m_nLampChange;
			}
			if (m_DriveData.bHLamp != dlg.m_bHLamp)
			{
				bChangeList[10] = TRUE;
				m_DriveData.bHLamp = dlg.m_bHLamp;
			}
			if (m_DriveData.bDLamp != dlg.m_bDLamp)
			{
				bChangeList[11] = TRUE;
				m_DriveData.bDLamp = dlg.m_bDLamp;
			}
			if (m_DriveData.bDoubleBeam != dlg.m_bDoubleBeam)
			{
				bChangeList[12] = TRUE;
				m_DriveData.bDoubleBeam = dlg.m_bDoubleBeam;
			}
			if (m_DriveData.nPlotMode != dlg.m_nPlotMode)
			{
				bChangeList[13] = TRUE;
				m_DriveData.nPlotMode = dlg.m_nPlotMode;
			}
			if (m_DriveData.nPlotSize != dlg.m_nPlotSize)
			{
				bChangeList[14] = TRUE;
				m_DriveData.nPlotSize = dlg.m_nPlotSize;
			}
			if (m_DriveData.nPlotX != dlg.m_nPlotX)
			{
				bChangeList[15] = TRUE;
				m_DriveData.nPlotX = dlg.m_nPlotX;
			}
			if (m_DriveData.nPlotY != dlg.m_nPlotY)
			{
				bChangeList[16] = TRUE;
				m_DriveData.nPlotY = dlg.m_nPlotY;
			}
		}
		// test
		//return;
		// test
		
		// go back to the Methods page, then select method
		sprintf(szSendString, "\x1B\x67\r");  // ESC g CR
		WriteCommString(szSendString);
		sprintf(szSendString, "\x1B\x32/1\r");  // ESC 2/1 CR
		WriteCommString(szSendString);
		
		// now actually send the changed values
		// to maximize speeed, we send the strings according to the appearance on screen
		if (bChangeList[0])
		{
			sprintf(szSendString, "\x1B\x31/%u\r", m_DriveData.nAbsMode + 1);  // ESC 1/1 CR or ESC 1/2 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[1])
		{
			sprintf(szSendString, "\x1B\x32/1/%u\r", m_DriveData.nWavelength);  // ESC 2/1/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[2])
		{
			sprintf(szSendString, "\x1B\x33/1/%.3f\r", m_DriveData.fYAxisMin);  // ESC 3/1/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[3])
		{
			sprintf(szSendString, "\x1B\x33/2/%.3f\r", m_DriveData.fYAxisMax);  // ESC 3/2/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[4])
		{
			sprintf(szSendString, "\x1B\x34/%u\r", m_DriveData.nSamplingRate + 1);  // ESC 4/1 CR through ESC 4/7 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[5])
		{
			sprintf(szSendString, "\x1B\x35/1/%.1f\r", m_DriveData.fMeasureTime);  // ESC 5/1/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[6])
		{
			sprintf(szSendString, "\x1B\x36/1/%u\r", m_DriveData.nCycleNumber);  // ESC 6/1/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[7])
		{
			sprintf(szSendString, "\x1B\x37/1/%.1f\r", m_DriveData.fCycleTime);  // ESC 7/1/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[8])
		{
			sprintf(szSendString, "\x1B\x39/%u\r", m_DriveData.nLampBandwidth + 1);  // ESC 9/1 CR through ESC 9/4 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[9])
		{
			sprintf(szSendString, "\x1B\x31\x30/1/%u\r", m_DriveData.nLampChange);  // ESC 10/1/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[10])
		{
			if (m_DriveData.bHLamp == TRUE)
				sprintf(szSendString, "\x1B\x31\x31/1\r");  // ESC 11/1 CR
			else
				sprintf(szSendString, "\x1B\x31\x31/2\r");  // ESC 11/2 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[11])
		{
			if (m_DriveData.bDLamp == TRUE)
				sprintf(szSendString, "\x1B\x31\x32/1\r");  // ESC 12/1 CR
			else
				sprintf(szSendString, "\x1B\x31\x32/2\r");  // ESC 12/2 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[12])
		{
			if (m_DriveData.bDoubleBeam == TRUE)
				sprintf(szSendString, "\x1B\x31\x33/1\r");  // ESC 13/1 CR
			else
				sprintf(szSendString, "\x1B\x31\x33/2\r");  // ESC 13/2 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[13])
		{
			sprintf(szSendString, "\x1B\x31\x35/%u\r", m_DriveData.nPlotMode + 1);  // ESC 15/1 CR through ESC 15/3 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[14])
		{
			sprintf(szSendString, "\x1B\x31\x37/1/%u\r", m_DriveData.nPlotSize);  // ESC 16/1/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[15])
		{
			sprintf(szSendString, "\x1B\x31\x37/%u\r", m_DriveData.nPlotX + 1);  // ESC 17/1 CR through ESC 17/8 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[16])
		{
			sprintf(szSendString, "\x1B\x31\x38/%u\r", m_DriveData.nPlotY + 1);  // ESC 18/1 CR through ESC 18/7 CR
			WriteCommString(szSendString);
		}
		
		// always set Data to RS232 to TRUE
		sprintf(szSendString, "\x1B\x32\x30/1\r");  // ESC 20/1 CR
		WriteCommString(szSendString);
	}
}

void CUvikonApp::OnUpdateMethodsTimedrive(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck(m_nMethodRadio == MET_TDRIVE);	// switch on if this is the current method	
	pCmdUI->Enable(m_bIsCollecting);	    // switch on if we're connected
}

/////////////////////////////////////////////////////////////////////////////////
// OnMethodsLambdascan(): Handler for the Methods-Lambdascan menu command
// To reduce the time spent to set the values on the method page, UVIKON monitors
// what has changed in the dialog box and sets only the changed values.
// As initially the Uvikon 860 default values are used, this works also when
// the methods dialog is used for the first time in a session
/////////////////////////////////////////////////////////////////////////////////
void CUvikonApp::OnMethodsLambdascan()
{
	CLScanDlg dlg;
	BOOL bChangeList[19];
	char szSendString[20];
	int i;
	
	dlg.m_bBaseline = m_ScanData.bBaseline;
	dlg.m_bDoubleBeam = m_ScanData.bDoubleBeam;
	dlg.m_nCycleNumber = m_ScanData.nCycleNumber;
	dlg.m_fCycleTime = m_ScanData.fCycleTime;
	dlg.m_bDLamp = m_ScanData.bDLamp;
	dlg.m_bHLamp = m_ScanData.bHLamp;
	dlg.m_nLampChange = m_ScanData.nLampChange;
	dlg.m_nAbsMode = m_ScanData.nAbsMode;
	dlg.m_nPlotMode = m_ScanData.nPlotMode;
	dlg.m_nPlotSize = m_ScanData.nPlotSize;
	dlg.m_nPlotX = m_ScanData.nPlotX;
	dlg.m_nPlotY = m_ScanData.nPlotY;
	dlg.m_nScanSpeed = m_ScanData.nScanSpeed;
	dlg.m_nXAxisMax = m_ScanData.nXAxisMax;
	dlg.m_nXAxisMin = m_ScanData.nXAxisMin;
	dlg.m_fYAxisMax = m_ScanData.fYAxisMax;
	dlg.m_fYAxisMin = m_ScanData.fYAxisMin;
	dlg.m_nLampBandwidth = m_ScanData.nLampBandwidth;
	dlg.m_nInterval = m_ScanData.nInterval;
	
	if (dlg.DoModal() == IDOK)
	{
		m_nMethodRadio = MET_LSCAN;

		if (dlg.m_bSendAll)
		{
			for (i = 0; i < 19; i++)           // set changeList to default
			{
				bChangeList[i] = TRUE;
			} 
		}
		else
		{
			for (i = 0; i < 19; i++)           // set changeList to default
			{
				bChangeList[i] = FALSE;
			} 
	
			// find out what has changed and copy the new values
			if (m_ScanData.bBaseline != dlg.m_bBaseline)
			{
				bChangeList[0] = TRUE;
				m_ScanData.bBaseline = dlg.m_bBaseline;
			}
			if (m_ScanData.bDoubleBeam != dlg.m_bDoubleBeam)
			{
				bChangeList[1] = TRUE;
				m_ScanData.bDoubleBeam = dlg.m_bDoubleBeam;
			}
			if (m_ScanData.nCycleNumber != dlg.m_nCycleNumber)
			{
				bChangeList[2] = TRUE;
				m_ScanData.nCycleNumber = dlg.m_nCycleNumber;
			}
			if (m_ScanData.fCycleTime != dlg.m_fCycleTime)
			{
				bChangeList[3] = TRUE;
				m_ScanData.fCycleTime = dlg.m_fCycleTime;
			}
			if (m_ScanData.bDLamp != dlg.m_bDLamp)
			{
				bChangeList[4] = TRUE;
				m_ScanData.bDLamp = dlg.m_bDLamp;
			}
			if (m_ScanData.bHLamp != dlg.m_bHLamp)
			{
				bChangeList[5] = TRUE;
				m_ScanData.bHLamp = dlg.m_bHLamp;
			}
			if (m_ScanData.nLampChange != dlg.m_nLampChange)
			{
				bChangeList[6] = TRUE;
				m_ScanData.nLampChange = dlg.m_nLampChange;
			}
			if (m_ScanData.nAbsMode != dlg.m_nAbsMode)
			{
				bChangeList[7] = TRUE;
				m_ScanData.nAbsMode = dlg.m_nAbsMode;
			}
			if (m_ScanData.nPlotMode != dlg.m_nPlotMode)
			{
				bChangeList[8] = TRUE;
				m_ScanData.nPlotMode = dlg.m_nPlotMode;
			}
			if (m_ScanData.nPlotSize != dlg.m_nPlotSize)
			{
				bChangeList[9] = TRUE;
				m_ScanData.nPlotSize = dlg.m_nPlotSize;
			}
			if (m_ScanData.nPlotX != dlg.m_nPlotX)
			{
				bChangeList[10] = TRUE;
				m_ScanData.nPlotX = dlg.m_nPlotX;
			}
			if (m_ScanData.nPlotY != dlg.m_nPlotY)
			{
				bChangeList[11] = TRUE;
				m_ScanData.nPlotY = dlg.m_nPlotY;
			}
			if (m_ScanData.nScanSpeed != dlg.m_nScanSpeed)
			{
				bChangeList[12] = TRUE;
				m_ScanData.nScanSpeed = dlg.m_nScanSpeed;
			}
			if (m_ScanData.nXAxisMax != dlg.m_nXAxisMax)
			{
				bChangeList[13] = TRUE;
				m_ScanData.nXAxisMax = dlg.m_nXAxisMax;
			}
			if (m_ScanData.nXAxisMin != dlg.m_nXAxisMin)
			{
				bChangeList[14] = TRUE;
				m_ScanData.nXAxisMin = dlg.m_nXAxisMin;
			}
			if (m_ScanData.fYAxisMax != dlg.m_fYAxisMax)
			{
				bChangeList[15] = TRUE;
				m_ScanData.fYAxisMax = dlg.m_fYAxisMax;
			}
			if (m_ScanData.fYAxisMin != dlg.m_fYAxisMin)
			{
				bChangeList[16] = TRUE;
				m_ScanData.fYAxisMin = dlg.m_fYAxisMin;
			}
			if (m_ScanData.nLampBandwidth != dlg.m_nLampBandwidth)
			{
				bChangeList[17] = TRUE;
				m_ScanData.nLampBandwidth = dlg.m_nLampBandwidth;
			}
			if (m_ScanData.nInterval != dlg.m_nInterval)
			{
				bChangeList[18] = TRUE;
				m_ScanData.nInterval = dlg.m_nInterval;
			}
		}
		// test
		//return;
		// test
		
		// go back to the Methods page, then select method
		sprintf(szSendString, "\x1B\x67\r");  // ESC g CR
		WriteCommString(szSendString);
		sprintf(szSendString, "\x1B\x31/1\r");  // ESC 1/1 CR
		WriteCommString(szSendString);
		
		// now actually send the changed values
		// to maximize speeed, we send the strings according to the appearance on screen
		if (bChangeList[7])
		{
			sprintf(szSendString, "\x1B\x31/%u\r", m_ScanData.nAbsMode + 1);  // ESC 1/1 CR or ESC 1/2 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[14])
		{
			sprintf(szSendString, "\x1B\x32/1/%u\r", m_ScanData.nXAxisMin);  // ESC 2/1/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[13])
		{
			sprintf(szSendString, "\x1B\x32/2/%u\r", m_ScanData.nXAxisMax);  // ESC 2/2/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[16])
		{
			sprintf(szSendString, "\x1B\x33/1/%.3f\r", m_ScanData.fYAxisMin);  // ESC 3/1/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[15])
		{
			sprintf(szSendString, "\x1B\x33/2/%.3f\r", m_ScanData.fYAxisMax);  // ESC 3/2/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[18])
		{
			sprintf(szSendString, "\x1B\x34/%u\r", m_ScanData.nInterval + 1);  // ESC 4/1 CR through ESC 4/7 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[12])
		{
			sprintf(szSendString, "\x1B\x35/%u\r", m_ScanData.nScanSpeed + 1);  // ESC 5/1 CR through ESC 5/7 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[2])
		{
			sprintf(szSendString, "\x1B\x36/1/%u\r", m_ScanData.nCycleNumber);  // ESC 6/1/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[3])
		{
			sprintf(szSendString, "\x1B\x37/1/%.1f\r", m_ScanData.fCycleTime);  // ESC 7/1/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[17])
		{
			sprintf(szSendString, "\x1B\x39/%u\r", m_ScanData.nLampBandwidth + 1);  // ESC 9/1 CR through ESC 9/4 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[6])
		{
			sprintf(szSendString, "\x1B\x31\x30/1/%u\r", m_ScanData.nLampChange);  // ESC 10/1/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[5])
		{
			if (m_ScanData.bHLamp == TRUE)
				sprintf(szSendString, "\x1B\x31\x31/1\r");  // ESC 11/1 CR
			else
				sprintf(szSendString, "\x1B\x31\x31/2\r");  // ESC 11/2 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[4])
		{
			if (m_ScanData.bDLamp == TRUE)
				sprintf(szSendString, "\x1B\x31\x32/1\r");  // ESC 12/1 CR
			else
				sprintf(szSendString, "\x1B\x31\x32/2\r");  // ESC 12/2 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[0])            // Baseline
		{
			if (m_ScanData.bBaseline == TRUE)
				sprintf(szSendString, "\x1B\x31\x33/1\r");  // ESC 13/1 CR
			else
				sprintf(szSendString, "\x1B\x31\x33/2\r");  // ESC 13/2 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[1])
		{
			if (m_ScanData.bDoubleBeam == TRUE)
				sprintf(szSendString, "\x1B\x31\x34/1\r");  // ESC 14/1 CR
			else
				sprintf(szSendString, "\x1B\x31\x34/2\r");  // ESC 14/2 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[8])
		{
			sprintf(szSendString, "\x1B\x31\x36/%u\r", m_ScanData.nPlotMode + 1);  // ESC 16/1 CR through ESC 16/3 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[9])
		{
			sprintf(szSendString, "\x1B\x31\x37/1/%u\r", m_ScanData.nPlotSize);  // ESC 17/1/X CR
			WriteCommString(szSendString);
		}
		if (bChangeList[10])
		{
			sprintf(szSendString, "\x1B\x31\x38/%u\r", m_ScanData.nPlotX + 1);  // ESC 18/1 CR through ESC 18/8 CR
			WriteCommString(szSendString);
		}
		if (bChangeList[11])
		{
			sprintf(szSendString, "\x1B\x31\x39/%u\r", m_ScanData.nPlotY + 1);  // ESC 19/1 CR through ESC 19/7 CR
			WriteCommString(szSendString);
		}
		
		// always set Data to RS232 to TRUE
		sprintf(szSendString, "\x1B\x32\x31/1\r");  // ESC 21/1 CR
		WriteCommString(szSendString);
	}
}

void CUvikonApp::OnUpdateMethodsLambdascan(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck(m_nMethodRadio == MET_LSCAN);	// switch on if this is the current method
	pCmdUI->Enable(m_bIsCollecting);	    // switch on if we're connected
}

/////////////////////////////////////////////////////////////////////////////////
// OnOptionsOutput(): Handler for the Options-Output menu command
/////////////////////////////////////////////////////////////////////////////
void CUvikonApp::OnOptionsOutput()
{
	COutptDlg dlg;
	
	dlg.m_nDecimal = m_nDecimal;
	dlg.m_nColumn = m_nColumn;
	dlg.m_bHeaderMethod = m_bHeaderMethod;
	dlg.m_bHeaderTime = m_bHeaderTime;
	dlg.m_bHeaderSample = m_bHeaderSample;
	
	if (dlg.DoModal() == IDOK)
	{
		m_nDecimal = dlg.m_nDecimal;
		m_nColumn = dlg.m_nColumn;
		m_bHeaderMethod = dlg.m_bHeaderMethod;
		m_bHeaderTime = dlg.m_bHeaderTime;
		m_bHeaderSample = dlg.m_bHeaderSample;
		
		switch (m_nDecimal)
		{
			case 0:
				m_szsDecimalPrivate[0] = m_szsDecimal[0];
				break;
			case 1:
				m_szsDecimalPrivate[0] = '.';
				break;
			case 2:
				m_szsDecimalPrivate[0] = ',';
				break;
		}
		 
		switch (m_nColumn)
		{
			case 0:
				m_szsColumn[0] = '\t';    // Tab
				break;
			case 1:
				m_szsColumn[0] = ' ';     // Space
				break;
			case 2:
				m_szsColumn[0] = '/';     // Slash
				break;
		}
	}
}

void CUvikonApp::OnUpdateOptionsOutput(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(/*!m_bIsCollecting*/TRUE);	// switch off if waiting for data	
}

/////////////////////////////////////////////////////////////////////////////////
// OnOptionsPort(): Handler for the Options-Port menu command
/////////////////////////////////////////////////////////////////////////////
void CUvikonApp::OnOptionsPort()
{
	CComSets dlg;
	
	dlg.m_nRadioBaudRate = m_nRadioBaudRate;
	dlg.m_nRadioParity = m_nRadioParity;
	dlg.m_nRadioStopBits = m_nRadioStopBits;
	dlg.m_nRadioDataBits = m_nRadioDataBits;
	dlg.m_nRadioPort = m_nRadioPort;
	
	if (dlg.DoModal() == IDOK)
	{
		m_nRadioBaudRate = dlg.m_nRadioBaudRate;
		m_nRadioParity = dlg.m_nRadioParity;
		m_nRadioStopBits = dlg.m_nRadioStopBits;
		m_nRadioDataBits = dlg.m_nRadioDataBits;
		m_nRadioPort = dlg.m_nRadioPort;
		MakeComString();
		//WriteUvikonSettings();
	}
	
}

void CUvikonApp::OnUpdateOptionsPort(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(!m_bIsCollecting);	// switch off if waiting for data	
}

////////////////////////////////////////////////////////////////////////////
// Functions

////////////////////////////////////////////////////////////////////////////////////
// InitializeComPort(): Initializes com port according to dialog settings
////////////////////////////////////////////////////////////////////////////////////
BOOL CUvikonApp::InitializeComPort()
{
	int err;
	DCB dcb;
	
	// TODO: if open com fails, call close com
	// Try to open COM port. Loop to allow user to close other COM apps
	do 
	{
		m_nIDComDev = OpenComm((const char _far*)&m_szPortName, RXQUEUE, TXQUEUE);
		if (m_nIDComDev < 0)
		{
			if (AfxMessageBox("COM port could not be initialized. Close or disconnect other apps addressing this COM port and try again", MB_RETRYCANCEL) == IDCANCEL)
				return FALSE;
		}
	}
	while (m_nIDComDev < 0);
	
	// get current device control block
	GetCommState(m_nIDComDev, &dcb ) ;
	
	dcb.BaudRate = GetBaudRate();
	dcb.ByteSize = GetDataBits();
	dcb.Parity = GetParity(TRUE);
	dcb.StopBits = GetStopBits(TRUE);
	
	// modify device control block to our needs
	// dcb.RlsTimeout = 0;
	dcb.CtsTimeout = 15000;
	// dcb.DsrTimeout = 0;
	dcb.fDtrDisable = 0;
	dcb.fRtsDisable = 0;
	dcb.EvtChar = ASCII_LF;    // event character is lf
	// dcb.fChEvt = 1;
	dcb.fBinary = 1;
	dcb.fParity = 1;
	// hardware flow control
	// dcb.fOutX = 0;
	// dcb.fInX = 0;
	dcb.fOutxCtsFlow = 1;
	// dcb.fOutxDsrFlow = 0;
	dcb.fRtsflow = 1;
	// dcb.fDtrflow = 1;
	
	// actually set the parameters defined in device control block
	err = SetCommState(&dcb);
	if (err < 0)
	{
		AfxMessageBox("COM port could not be initialized. Check the COM settings.");
		return FALSE;
	}
	
	// enable event notification for document window
    SetCommEventMask(m_nIDComDev, EV_RXFLAG) ;   // we will be notified whenever a cr is sent (dcb.EvtChar)
    // we will receive only CN_EVENT messages
    
	return TRUE;
}

////////////////////////////////////////////////////////////////////////////////////
// CloseComPort(): Closes com port
// Return: TRUE if successful, FALSE if error occurred
////////////////////////////////////////////////////////////////////////////////////
BOOL CUvikonApp::CloseComPort()
{
	// disable event notification
	EnableCommNotification(m_nIDComDev, NULL, -1,-1);

	
	if (CloseComm(m_nIDComDev) < 0)
	{
		AfxMessageBox("COM port could not be closed properly");
		return FALSE;
	}
	
	
	return TRUE;
}

////////////////////////////////////////////////////////////////////////////////////
// WriteCommString(): Writes a string to the COM port
// string: ptr to string
// Return: TRUE if successful, FALSE if error
////////////////////////////////////////////////////////////////////////////////////	
BOOL CUvikonApp::WriteCommString(char* string)
{
	COMSTAT stat;
	BOOL error;
	MSG msg;
	long i = 1000000;
	
	/*// get error status from COM port
	GetCommError(m_nIDComDev, &stat);
	
	// check whether enough space in send queue
	if (stat.cbOutQue < MAXOUTBLOCK - strlen(string))
	{
		if (WriteComm(m_nIDComDev, (const void FAR*)string, strlen(string)) < (int)strlen(string))
		{
			GetCommError(m_nIDComDev, &stat);
			error = TRUE;
		}
		else
		{
			error = FALSE;
		}
	}
	else
	{
		error = TRUE;
	}*/
	
	do       // a slimy hack to enforce the strings to be sent individually
	{
		GetCommError(m_nIDComDev, &stat);
		i--;
		PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE );
	}
	while (stat.cbOutQue > 0 && i > 0);
	
	if (stat.cbOutQue < MAXOUTBLOCK - strlen(string))
	{
		if (WriteComm(m_nIDComDev, (const void FAR*)string, strlen(string)) < (int)strlen(string))
		{
			GetCommError(m_nIDComDev, &stat);
			error = TRUE;
		}
		else
		{
			error = FALSE;
		}
	}
	else
	{
		error = TRUE;
	}
	
	return error;	
}

////////////////////////////////////////////////////////////////////////////////////
// ExitInstance(): Called when application quits
//                 Here we close the com port if necessary
// Return: 0 if no error, > 0 if error occurred
////////////////////////////////////////////////////////////////////////////////////
int CUvikonApp::ExitInstance()
{
	int retValue;
	
	retValue = CWinApp::ExitInstance();
	if (m_bIsCollecting)
	{
		if (!CloseComPort())
		{
			retValue += 1;
		}
	}
	WriteUvikonSettings();
	return retValue;
}

////////////////////////////////////////////////////////////////////////////////////
// Helpers for accessing ini file

////////////////////////////////////////////////////////////////////////////////////
// ReadUvikonSettings(): Reads settings from ini file
////////////////////////////////////////////////////////////////////////////////////
void CUvikonApp::ReadUvikonSettings()
{
	CString string;
	
	m_nRadioBaudRate = GetProfileInt(iniSection2, iniBaud, 1);
	m_nRadioParity = GetProfileInt(iniSection2, iniParity, 0);
	m_nRadioStopBits = GetProfileInt(iniSection2, iniStop, 0);
	m_nRadioDataBits = GetProfileInt(iniSection2, iniData, 1);
	m_nRadioPort = GetProfileInt(iniSection2, iniPort, 0);
	MakeComString();
	string = GetProfileString(iniSection3, iniDecimal, ".");
	strcpy(m_szsDecimalPrivate, string); 
	m_nDecimal = GetProfileInt(iniSection3, iniDecSet, 0);
	m_nColumn = GetProfileInt(iniSection3, iniColSet, 0);
	switch (m_nColumn)
	{
		case 0:
			m_szsColumn[0] = '\t';    // Tab
			break;
		case 1:
			m_szsColumn[0] = ' ';     // Space
			break;
		case 2:
			m_szsColumn[0] = '/';     // Slash
			break;
	}
	m_szsColumn[1] = '\0';
	m_bHeaderMethod = (BOOL)GetProfileInt(iniSection3, iniHeaderMet, 0);
	m_bHeaderTime = (BOOL)GetProfileInt(iniSection3, iniHeaderTime, 0);
	m_bHeaderSample = (BOOL)GetProfileInt(iniSection3, iniHeaderSample, 0);
}

////////////////////////////////////////////////////////////////////////////////////
// WriteUvikonSettings(): Writes settings to ini file
////////////////////////////////////////////////////////////////////////////////////
void CUvikonApp::WriteUvikonSettings()
{
	CString buffer;
	
	WriteProfileInt(iniSection2, iniBaud, m_nRadioBaudRate);
	WriteProfileInt(iniSection2, iniParity, m_nRadioParity);
	WriteProfileInt(iniSection2, iniStop, m_nRadioStopBits);
	WriteProfileInt(iniSection2, iniData, m_nRadioDataBits);
	WriteProfileInt(iniSection2, iniPort, m_nRadioPort);
	WriteProfileString(iniSection3, iniDecimal, m_szsDecimalPrivate);
	WriteProfileInt(iniSection3, iniDecSet, m_nDecimal);
	WriteProfileInt(iniSection3, iniColSet, m_nColumn);
	WriteProfileInt(iniSection3, iniHeaderMet, m_bHeaderMethod);
	WriteProfileInt(iniSection3, iniHeaderTime, m_bHeaderTime);
	WriteProfileInt(iniSection3, iniHeaderSample, m_bHeaderSample);
}

////////////////////////////////////////////////////////////////////////////////////
// ReadWinIni(): Reads settings from win.ini
//               Must be called *after* ReadUvikonSettings()
////////////////////////////////////////////////////////////////////////////////////
void CUvikonApp::ReadWinIni()
{
	CString string;
	// Read intl settings
	string = GetProfileString("intl", "sDecimal", ".");
	strcpy(m_szsDecimal, string);
	
	// if Windows default is set, modify the current settings
	if (m_nDecimal == 0)
	{
		m_szsDecimalPrivate[0] = m_szsDecimal[0];
	}
}

/////////////////////////////////////////////////////////////////////////////////////
// some helpers

char* CUvikonApp::MakeComString()
{
	sprintf(m_szPortName, "COM%i", m_nRadioPort+1);
    return m_szPortName;
}

BYTE CUvikonApp::GetDataBits()
{
	BYTE DataBits;
	
	DataBits = (m_nRadioDataBits == 0) ? 7:8;
	
	return DataBits;
}

WORD CUvikonApp::GetBaudRate()
{
	WORD BaudRate;
	
	switch (m_nRadioBaudRate)
	{
		case 0:
			BaudRate = 1200;
			break;
		case 1:
			BaudRate = 2400;
			break;
		case 2:
			BaudRate = 9600;
			break;
	}
	return BaudRate;
}

BYTE CUvikonApp::GetParity(BOOL dcb)
{
	BYTE Parity;
	
	if (dcb)
	{
		switch (m_nRadioParity)
		{
			case 0:
				Parity = NOPARITY;
				break;
			case 1:
				Parity = EVENPARITY;
				break;
			case 2:
				Parity = ODDPARITY;
				break;
		}	}
	else
	{
		switch (m_nRadioParity)
		{
			case 0:
				Parity = 'n';
				break;
			case 1:
				Parity = 'e';
				break;
			case 2:
				Parity = 'o';
				break;
		}
	}
    return Parity;
}

BYTE CUvikonApp::GetStopBits(BOOL dcb)
{
	BYTE StopBits;
	
	if (dcb)
	{
		switch (m_nRadioStopBits)
		{
			case 0:
				StopBits = ONESTOPBIT;
				break;
			case 1:
				StopBits = ONE5STOPBITS;
				break;
			case 2:
				StopBits = TWOSTOPBITS;
				break;
		}
	}
	else
	{
		switch (m_nRadioStopBits)
		{
			case 0:
				StopBits = 1;
				break;
			case 1:
				StopBits = 1;
				break;
			case 2:
				StopBits = 2;
				break;
		}
	}
    return StopBits;
}

int CUvikonApp::GetCOMID()
{
	return m_nIDComDev;
}

BOOL CUvikonApp::GetIsCollecting()
{
	return m_bIsCollecting;
}

int CUvikonApp::GetRunType()
{
	return m_nRunType;
}

void CUvikonApp::SetRunType(int nRunType)
{
	m_nRunType = nRunType;
}

char CUvikonApp::GetDecimalSeparator()
{
	return m_szsDecimalPrivate[0];	
}

char CUvikonApp::GetColumnSeparator()
{
	return m_szsColumn[0];	
}

int CUvikonApp::GetMethod()
{
	return m_nMethodRadio;
}

CMethodData* CUvikonApp::GetMethodData()
{
	switch (m_nMethodRadio)
	{
		case MET_DEFAULT:
			return NULL;
			break;
		case MET_LSCAN:
			return &m_ScanData;
			break;
		case MET_LFIX:
			return &m_FixData;
			break;
		case MET_TDRIVE:
			return &m_DriveData;
			break;
	}
	return NULL;
}

BOOL CUvikonApp::GetHeaderMethod()
{
	return m_bHeaderMethod;
}

BOOL CUvikonApp::GetHeaderTime()
{
	return m_bHeaderTime;
}

BOOL CUvikonApp::GetHeaderSample()
{
	return m_bHeaderSample;
}

