// uvikodoc.h : interface of the CUvikonDoc class
//
/////////////////////////////////////////////////////////////////////////////

class CData : public CObject
{
public:
	DECLARE_SERIAL(CData)
	CData();
// Attributes
public:
	CString m_szData;     // contains data
	CString m_szTitle;    // contains the header
	int m_nMethod;			// contains method
	BOOL m_bSelected;	   // TRUE if item selected, FALSE if not
// Implementation
public:
	virtual ~CData();
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
};


class CUvikonDoc : public CDocument
{
protected: // create from serialization only
	CUvikonDoc();
	DECLARE_DYNCREATE(CUvikonDoc)

// Attributes
public:
	CUIntArray m_UpdateIndex;  // Array holds indices of all lines that need to be redrawn
private:
	CObArray m_Data;     // Array holds ptrs to CData objects
	CObArray m_UndoData; // Array holds ptrs to "undoable" CData objects
	CUIntArray m_UndoIndex;	// Array holds indices of previous position of "undoable" objects
	int m_nUndoType;	// holds type of operation to undo
	int m_nPrevIndex; // holds previous index of undo object(s)
	int m_nCurrentRun;   // index to current run, -1 if no runs available
	BOOL m_bFirstFix;	// TRUE if first fix sample, FALSE if not
	CSize m_DocSize;	// current size of document
	CSize m_PrevDocSize;	// previous size of document
	int m_nSelected;			// counter of selected items in listbox
	int m_nSelExtent;		// extent of selection range
// Operations
public:
	int GetNumRun();		// returns number of runs in document
	int GetCurrentRun();	// returns number of current run
	BOOL StartNewRun(CString* pszTitle, int nMethod, int nCXSize, TEXTMETRIC* pTm);	// Sets run title
	void UpdateRun(CEdit& Data);			// updates current run data
	BOOL IsFirstFix();						// returns m_bFirstFix
	void SetFirstFix(BOOL bFirst);			// sets m_bFirstFix state
	void SetCurrentRun(int nRun, BOOL bScrollToPos);			// sets currently selected run
	int SetCurrentRunRel(BOOL bUp);		// moves selection up or down
	void EditClear(BOOL bAll, CDC* pDC, TEXTMETRIC* pTm);			// deletes run
	void Undo();							// undo handler
	CString* GetData();						// returns ptr to current data
	void InitializeListBox(CDC* pDC, TEXTMETRIC* pTm);	// initializes listbox after doc is created
	BOOL IsUndo();							// returns whether something to undo
	BOOL CopyToClpbd();           // copy data to clipboard as text
	void CopyFromClpbd(CDC* pDC, TEXTMETRIC* pTm);                   // copy data from clipboard
	CSize GetDocSize();                     // returns current size of document
	CString* GetRunTitle(int nIndex);	// returns title of run
	void SetRunTitle(int nIndex, CString* pszTitle, CDC* pDC, TEXTMETRIC* pTm); // sets title of run
	int GetIsSelected(int nIndex);				// returns whether item is selected
	int GetNumSelected();					// returns number of selected items
	void ToggleItemSelection(int nIndex, BOOL bToggle, BOOL bNewState);	// toggles selection state
	void SelectRange(int nAnchorLine, int nIndex);	// selects a range of items
	void SetModified();						// sets the modified flag
	void ResetSelExtent();					// resets sel extent after lbutton up
	void CompactMem();						// frees extra memory after WM_COMPACTING
private:
	void ClearUndoBuffer();					// clears undo buffer
	CView* GetListView();				// get a ptr to the listbox view
	CView* GetUvikonView();				// get a ptr to the edit view
	void SortArray(int* pArray, int numItems);		// sorts selection in a listbox
	int GetSelItems(LPINT rgIndex);   // fills array with indices of selected items
	void SetDocSize(CDC* pDC, TEXTMETRIC* pTm);         // adjusts doc size after change in doc
// Implementation
public:
	virtual ~CUvikonDoc();
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	virtual BOOL OnNewDocument();
	virtual BOOL OnSaveDocument(const char* pszPathName);
	virtual BOOL CanCloseFrame(CFrameWnd* pFrame);

// Generated message map functions
protected:
	//{{AFX_MSG(CUvikonDoc)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
