// tdrivdlg.cpp : implementation file
//

#include "stdafx.h"
#include "uvikon.h"
#include "tdrivdlg.h"
#include "comfns.h"

#include <afx.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

static char szFilter[] = "Time drive (*.tdr)|*.tdr | All Files (*.*)|*.*||";
/////////////////////////////////////////////////////////////////////////////
// CTDrivDlg dialog


CTDrivDlg::CTDrivDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTDrivDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTDrivDlg)
	m_nLampBandwidth = 1;
	m_nCycleNumber = 1;
	m_fCycleTime = .1;
	m_bDLamp = TRUE;
	m_bHLamp = TRUE;
	m_nLampChange = 340;
	m_fMeasureTime = 10;
	m_nAbsMode = 0;
	m_nPlotMode = 2;
	m_nPlotSize = 20;
	m_nPlotX = 7;
	m_nPlotY = 6;
	m_nSamplingRate = 3;
	m_nWavelength = 540;
	m_fYAxisMax = 3;
	m_fYAxisMin = 0;
	m_bDoubleBeam = TRUE;
	m_bSendAll = FALSE;
	//}}AFX_DATA_INIT
}

void CTDrivDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTDrivDlg)
	DDX_CBIndex(pDX, IDC_BANDWIDTH, m_nLampBandwidth);
	DDX_Text(pDX, IDC_CYCLENUM, m_nCycleNumber);
	DDV_MinMaxInt(pDX, m_nCycleNumber, 1, 99);
	DDX_Text(pDX, IDC_CYCLETIME, m_fCycleTime);
	DDV_MinMaxFloat(pDX, m_fCycleTime, 0.1, 9999.);
	DDX_Check(pDX, IDC_DLAMP, m_bDLamp);
	DDX_Check(pDX, IDC_HLAMP, m_bHLamp);
	DDX_Text(pDX, IDC_LAMPCHANGE, m_nLampChange);
	DDV_MinMaxInt(pDX, m_nLampChange, 290, 400);
	DDX_Text(pDX, IDC_MEASURETIME, m_fMeasureTime);
	DDV_MinMaxFloat(pDX, m_fMeasureTime, 10., 9999.);
	DDX_Radio(pDX, IDC_MODE1, m_nAbsMode);
	DDX_CBIndex(pDX, IDC_PLOTMODE, m_nPlotMode);
	DDX_Text(pDX, IDC_PLOTSIZE, m_nPlotSize);
	DDV_MinMaxInt(pDX, m_nPlotSize, 5, 150);
	DDX_CBIndex(pDX, IDC_PLOTX, m_nPlotX);
	DDX_CBIndex(pDX, IDC_PLOTY, m_nPlotY);
	DDX_CBIndex(pDX, IDC_SAMPLINGRATE, m_nSamplingRate);
	DDX_Text(pDX, IDC_WAVELENGTH, m_nWavelength);
	DDV_MinMaxInt(pDX, m_nWavelength, 180, 900);
	DDX_Text(pDX, IDC_YAXISMAX, m_fYAxisMax);
	DDV_MinMaxFloat(pDX, m_fYAxisMax, -0.3, 4.);
	DDX_Text(pDX, IDC_YAXISMIN, m_fYAxisMin);
	DDV_MinMaxFloat(pDX, m_fYAxisMin, -0.3, 4.);
	DDX_Check(pDX, IDC_BEAM, m_bDoubleBeam);
	DDX_Check(pDX, IDC_SENDALL, m_bSendAll);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTDrivDlg, CDialog)
	//{{AFX_MSG_MAP(CTDrivDlg)
	ON_BN_CLICKED(IDC_LOADMETHOD, OnLoadmethod)
	ON_BN_CLICKED(IDC_SAVEMETHOD, OnSavemethod)
	ON_BN_CLICKED(IDC_DEFAULT, OnDefault)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CTDrivDlg message handlers

BOOL CTDrivDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	::CenterWindow(GetParent(), this);    // center dialog in frame window
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////////////////
// OnLoadmethod(): Handler for the Load method button
/////////////////////////////////////////////////////////////////////////////////////////
void CTDrivDlg::OnLoadmethod()
{
	CFileDialog dlg(TRUE, ".tdr", NULL, OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT, szFilter);
	
	if (dlg.DoModal() == IDOK)
	{
		CFile theFile;
		theFile.Open(dlg.GetPathName(), CFile::shareDenyWrite|CFile::modeRead);
		CArchive archive(&theFile, CArchive::load);
		m_DriveData.Serialize(archive);
		archive.Close();
		theFile.Close();
		
		FillMembers(FALSE);		// copy m_DriveData values to member variables
		UpdateData(FALSE);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////
// OnSavemethod(): Handler for the Save method button
/////////////////////////////////////////////////////////////////////////////////////////
void CTDrivDlg::OnSavemethod()
{
	CFileDialog dlg(FALSE, ".tdr", NULL, OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT, szFilter);
	
	if (dlg.DoModal() == IDOK)
	{
		UpdateData(TRUE);
		FillMembers(TRUE);
		
		CFile theFile;
		theFile.Open(dlg.GetPathName(), CFile::shareDenyWrite|CFile::modeCreate|CFile::modeWrite);
		CArchive archive(&theFile, CArchive::store);
		m_DriveData.Serialize(archive);
		archive.Close();
		theFile.Close();
	}
}

//////////////////////////////////////////////////////////////////////////////
// OnDefault(): Handler for Default button. Sets instrument default values
//////////////////////////////////////////////////////////////////////////////
void CTDrivDlg::OnDefault()
{
	m_DriveData.SetDefault();
	FillMembers(FALSE);
	UpdateData(FALSE);
}

///////////////////////////////////////////////////////////////////////////////
// FillMembers(): Fills member variables
// Argument: set: if TRUE, m_ScanData is updated from member variables
//                if FALSE, member variables are updated from m_ScanData
///////////////////////////////////////////////////////////////////////////////
void CTDrivDlg::FillMembers(BOOL set)
{
	if (set)
	{
		m_DriveData.bDoubleBeam = m_bDoubleBeam;
		m_DriveData.nCycleNumber = m_nCycleNumber;
		m_DriveData.bDLamp = m_bDLamp;
		m_DriveData.bHLamp = m_bHLamp;
		m_DriveData.nLampChange = m_nLampChange;
		m_DriveData.nAbsMode = m_nAbsMode;
		m_DriveData.nLampBandwidth = m_nLampBandwidth;
		m_DriveData.fCycleTime = m_fCycleTime;
		
		m_DriveData.nWavelength = m_nWavelength;
		m_DriveData.fYAxisMax = m_fYAxisMax;
		m_DriveData.fYAxisMin = m_fYAxisMin;
		m_DriveData.nSamplingRate = m_nSamplingRate;
		m_DriveData.fMeasureTime = m_fMeasureTime;
		m_DriveData.nPlotMode = m_nPlotMode;
		m_DriveData.nPlotSize = m_nPlotSize;
		m_DriveData.nPlotX = m_nPlotX;
		m_DriveData.nPlotY = m_nPlotY;
	}
	else
	{
		m_bDoubleBeam = m_DriveData.bDoubleBeam;
		m_nCycleNumber = m_DriveData.nCycleNumber;
		m_bDLamp = m_DriveData.bDLamp;
		m_bHLamp = m_DriveData.bHLamp;
		m_nLampChange = m_DriveData.nLampChange;
		m_nAbsMode = m_DriveData.nAbsMode;
		m_nLampBandwidth = m_DriveData.nLampBandwidth;
		m_fCycleTime = m_DriveData.fCycleTime;

		m_nWavelength = m_DriveData.nWavelength;
		m_nPlotMode = m_DriveData.nPlotMode;
		m_fYAxisMax = m_DriveData.fYAxisMax;
		m_fYAxisMin = m_DriveData.fYAxisMin;
		m_nSamplingRate = m_DriveData.nSamplingRate;
		m_fMeasureTime = m_DriveData.fMeasureTime;
		m_nPlotSize = m_DriveData.nPlotSize;
		m_nPlotX = m_DriveData.nPlotX;
		m_nPlotY = m_DriveData.nPlotY;
	}
}
		
