// splitwnd.cpp : implementation file
//

#include "stdafx.h"
#include "uvikon.h"
#include "splitwnd.h"
#include "listview.h"
#include "uvikovw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSplitWnd

IMPLEMENT_DYNCREATE(CSplitWnd, CMDIChildWnd)

CSplitWnd::CSplitWnd()
{
}

CSplitWnd::~CSplitWnd()
{
}

BOOL CSplitWnd::OnCreateClient(LPCREATESTRUCT,
	 CCreateContext* pContext)
{
	// create a splitter with 1 row, 2 columns
	if (!m_wndSplitter.CreateStatic(this, 1, 2))
	{
		TRACE("Failed to CreateStaticSplitter\n");
		return FALSE;
	}

	// add the first splitter pane - the default view (CEditView) in column 1
	if (!m_wndSplitter.CreateView(0, 1,
		pContext->m_pNewViewClass, CSize(130, 50), pContext))
	{
		TRACE("Failed to create first pane\n");
		return FALSE;
	}

	// add the second splitter pane - the listbox in column 0
	if (!m_wndSplitter.CreateView(0, 0,
		RUNTIME_CLASS(CListView), CSize(186, 130), pContext))
	{
		TRACE("Failed to create second pane\n");
		return FALSE;
	}

	// activate the input view
	SetActiveView((CView*)m_wndSplitter.GetPane(0,1));

	return TRUE;
}

BEGIN_MESSAGE_MAP(CSplitWnd, CMDIChildWnd)
	//{{AFX_MSG_MAP(CSplitWnd)
	ON_COMMAND(ID_RUN_READCURVE, OnRunReadcurve)
	ON_UPDATE_COMMAND_UI(ID_RUN_READCURVE, OnUpdateRunReadcurve)
	ON_COMMAND(ID_RUN_RESET, OnRunReset)
	ON_UPDATE_COMMAND_UI(ID_RUN_RESET, OnUpdateRunReset)
	ON_COMMAND(ID_RUN_RUNBASELINE, OnRunRunbaseline)
	ON_UPDATE_COMMAND_UI(ID_RUN_RUNBASELINE, OnUpdateRunRunbaseline)
	ON_COMMAND(ID_RUN_RUNSAMPLE, OnRunRunsample)
	ON_UPDATE_COMMAND_UI(ID_RUN_RUNSAMPLE, OnUpdateRunRunsample)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSplitWnd message handlers


// Handlers meant for CUvikonView. Implementing the message handlers in CSplitWnd
// means that this command is available regardless of whether the input focus is
// in the data pane or in the overview pane. We simply forward the messages to the
// appropriate handlers in CUvikonView

void CSplitWnd::OnRunReadcurve()
{
	((CUvikonView*)m_wndSplitter.GetPane(0,1))->OnRunReadcurve();
}

void CSplitWnd::OnUpdateRunReadcurve(CCmdUI* pCmdUI)
{
	((CUvikonView*)m_wndSplitter.GetPane(0,1))->OnUpdateRunReadcurve(pCmdUI);
}

void CSplitWnd::OnRunReset()
{
	((CUvikonView*)m_wndSplitter.GetPane(0,1))->OnRunReset();
}

void CSplitWnd::OnUpdateRunReset(CCmdUI* pCmdUI)
{
	((CUvikonView*)m_wndSplitter.GetPane(0,1))->OnUpdateRunReset(pCmdUI);
}

void CSplitWnd::OnRunRunbaseline()
{
	((CUvikonView*)m_wndSplitter.GetPane(0,1))->OnRunRunbaseline();
}

void CSplitWnd::OnUpdateRunRunbaseline(CCmdUI* pCmdUI)
{
	((CUvikonView*)m_wndSplitter.GetPane(0,1))->OnUpdateRunRunbaseline(pCmdUI);
}

void CSplitWnd::OnRunRunsample()
{
	((CUvikonView*)m_wndSplitter.GetPane(0,1))->OnRunRunsample();
}

void CSplitWnd::OnUpdateRunRunsample(CCmdUI* pCmdUI)
{
	((CUvikonView*)m_wndSplitter.GetPane(0,1))->OnUpdateRunRunsample(pCmdUI);
}

