// Methods data classes - header file

////////////////////////////////////////////////////////////////
// CMethodData: Base class of method data classes
class CMethodData : public CObject
{
public:
	DECLARE_SERIAL(CMethodData)
	CMethodData(){};	// empty constructor
	~CMethodData(){};	// destructor

// member variables
public:
	int		nAbsMode;
	int		nCycleNumber;
	float	fCycleTime;
	BOOL	bDoubleBeam;
	BOOL	bDLamp;
	BOOL	bHLamp;
	int		nLampChange;
	int		nLampBandwidth;

// Interface
public:
	virtual void WriteMethodsHeader(CString* lpszHeader);
	void Serialize(CArchive& archive);
	void SetDefault();
	
private:
};


/////////////////////////////////////////////////////////////////
// CScanData: Scan method data class
class CScanData : public CMethodData
{
public:
	DECLARE_SERIAL(CScanData)
	CScanData(){};	// empty constructor
	~CScanData(){};	// destructor

// Interface
public:
	virtual void WriteMethodsHeader(CString* lpszHeader);
	void Serialize(CArchive& archive);
	void SetDefault();

// member variables	
public:
	BOOL	bBaseline;
	int		nPlotMode;
	int		nPlotSize;
	int		nPlotX;
	int		nPlotY;
	int		nScanSpeed;
	int		nXAxisMax;
	int		nXAxisMin;
	float	fYAxisMax;
	float	fYAxisMin;
	int		nInterval;

	
};

/////////////////////////////////////////////////////////////////
// CFixData: Lambda fix method data class
class CFixData : public CMethodData
{
public:
	DECLARE_SERIAL(CFixData)
	CFixData(){};	// empty constructor
	~CFixData(){};	// destructor

// Interface
public:
	virtual void WriteMethodsHeader(CString* lpszHeader);
	void Serialize(CArchive& archive);
	void SetDefault();

// member variables	
public:
	float fConcFactor;
	int nIntegrationTime;
	BOOL bPlotMode;
	float fStandardConc;
	int nUnit;
	int nWavelength;
};

/////////////////////////////////////////////////////////////////
// CDriveData: Time drive method data class
class CDriveData : public CMethodData
{
public:
	DECLARE_SERIAL(CDriveData)
	CDriveData(){};	// empty constructor
	~CDriveData(){};	// destructor

// Interface
public:
	virtual void WriteMethodsHeader(CString* lpszHeader);
	void Serialize(CArchive& archive);
	void SetDefault();

// member variables	
public:
	int		nPlotMode;
	int		nPlotSize;
	int		nPlotX;
	int		nPlotY;
	float	fYAxisMax;
	float	fYAxisMin;
    int		nWavelength;
	int		nSamplingRate;
	float	fMeasureTime;
	
};

