// Methods data classes - implementation file

#include "stdafx.h"
#include "metdata.h"
#include <string.h>

#include <afx.h>

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
// Class CMethodData: Implementation
IMPLEMENT_SERIAL(CMethodData, CObject, 1)

////////////////////////////////////////////////////////////////////////////////////////////
// WriteMethodsHeader(): Writes header to string
// Argument: lpszHeader: ptr to string which will hold header
////////////////////////////////////////////////////////////////////////////////////////////
void CMethodData::WriteMethodsHeader(CString* lpszHeader)
{
	char buffer[50];

	switch (nAbsMode)
	{
		case 0:
			*lpszHeader += "Mode: abs\r\n";
			break;
		case 1:
			*lpszHeader += "Mode: %T\r\n";
			break;
		case 2:
			*lpszHeader += "Mode: conc\r\n";
			break;
	}

	sprintf(buffer, "Cycle number: %i\r\n", nCycleNumber);
	*lpszHeader += buffer;
	
	sprintf(buffer, "Cycle time: %.1f\r\n", fCycleTime);
	*lpszHeader += buffer;
	
	switch (nLampBandwidth)
	{
		case 0:
			*lpszHeader += "Spectral bandwidth: 4 nm\r\n";
			break;
		case 1:
			*lpszHeader += "Spectral bandwidth: 2 nm\r\n";
			break;
		case 2:
			*lpszHeader += "Spectral bandwidth: 1 nm\r\n";
			break;
		case 3:
			*lpszHeader += "Spectral bandwidth: 0.5 nm\r\n";
	}

	sprintf(buffer, "Lamp change: %i\r\n", nLampChange);
	*lpszHeader += buffer;
	
	if (bHLamp == TRUE)
		*lpszHeader += "H lamp: on\r\n";
	else
		*lpszHeader += "H lamp: off\r\n";
		
	if (bDLamp == TRUE)
		*lpszHeader += "D2 lamp: on\r\n";
	else
		*lpszHeader += "D2 lamp: off\r\n";
		
	if (bDoubleBeam == TRUE)
		*lpszHeader += "Beam: double\r\n";
	else
		*lpszHeader += "Beam: single\r\n";
		
}

///////////////////////////////////////////////////////////////////////////////
// SetDefault(): Sets default values for method parameters
///////////////////////////////////////////////////////////////////////////////
void CMethodData::SetDefault()
{
	nAbsMode = 0;
	bDoubleBeam = TRUE;
	nCycleNumber = 1;
	fCycleTime = 0.1;
	bDLamp = TRUE;
	bHLamp = TRUE;
	nLampChange = 340;
	nLampBandwidth = 1;
}

/////////////////////////////////////////////////////////////////////////////////////
// Serialize(): Serializes member variables into archive
// Argument: archive: reference to CArchive
/////////////////////////////////////////////////////////////////////////////////////
void CMethodData::Serialize(CArchive& archive)
{
	// call base class routine
	CObject::Serialize(archive);
	
	if (archive.IsStoring())
	{
		archive.Write(&nAbsMode, sizeof(nAbsMode));
		archive.Write(&bDoubleBeam, sizeof(bDoubleBeam));
		archive.Write(&nCycleNumber, sizeof(nCycleNumber));
		archive.Write(&fCycleTime, sizeof(fCycleTime));
		archive.Write(&bDLamp, sizeof(bDLamp));
		archive.Write(&bHLamp, sizeof(bHLamp));
		archive.Write(&nLampChange, sizeof(nLampChange));
		archive.Write(&nLampBandwidth, sizeof(nLampBandwidth));
	}
	else
	{
		archive.Read(&nAbsMode, sizeof(nAbsMode));
		archive.Read(&bDoubleBeam, sizeof(bDoubleBeam));
		archive.Read(&nCycleNumber, sizeof(nCycleNumber));
		archive.Read(&fCycleTime, sizeof(fCycleTime));
		archive.Read(&bDLamp, sizeof(bDLamp));
		archive.Read(&bHLamp, sizeof(bHLamp));
		archive.Read(&nLampChange, sizeof(nLampChange));
		archive.Read(&nLampBandwidth, sizeof(nLampBandwidth));
	}
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
// Class CScanData: Implementation
IMPLEMENT_SERIAL(CScanData, CMethodData, 1)

////////////////////////////////////////////////////////////////////////////////////////////
// WriteMethodsHeader(): Writes header to string
// Argument: lpszHeader: ptr to string which will hold header
////////////////////////////////////////////////////////////////////////////////////////////
void CScanData::WriteMethodsHeader(CString* lpszHeader)
{
	char buffer[50];
	
	*lpszHeader += "Lambda scan\r\n";
	
	sprintf(buffer, "X axis min*max: %i*%i\r\n", nXAxisMin, nXAxisMax);
	*lpszHeader += buffer;
	
	sprintf(buffer, "Y axis min*max: %.3f*%.3f\r\n", fYAxisMin, fYAxisMax);
	*lpszHeader += buffer;
	
	switch (nInterval)
	{
		case 0:
			*lpszHeader += "Sampling interval: 2 nm\r\n";
			break;
		case 1:
			*lpszHeader += "Sampling interval: 1 nm\r\n";
			break;
		case 2:
			*lpszHeader += "Sampling interval: 0.5 nm\r\n";
			break;
		case 3:
			*lpszHeader += "Sampling interval: 0.25 nm\r\n";
			break;
		case 4:
			*lpszHeader += "Sampling interval: 0.1 nm\r\n";
			break;
		case 5:
			*lpszHeader += "Sampling interval: 0.05 nm\r\n";
			break;
		case 6:
			*lpszHeader += "Sampling interval: 0.025 nm\r\n";
	}

	switch (nScanSpeed)
	{
		case 0:
			*lpszHeader += "Scan speed: 1000 nm/min\r\n";
			break;
		case 1:
			*lpszHeader += "Scan speed: 500 nm/min\r\n";
			break;
		case 2:
			*lpszHeader += "Scan speed: 250 nm/min\r\n";
			break;
		case 3:
			*lpszHeader += "Scan speed: 100 nm/min\r\n";
			break;
		case 4:
			*lpszHeader += "Scan speed: 50 nm/min\r\n";
			break;
		case 5:
			*lpszHeader += "Scan speed: 25 nm/min\r\n";
			break;
		case 6:
			*lpszHeader += "Scan speed: 10 nm/min\r\n";
	}
	
	if (bBaseline == TRUE)
		*lpszHeader += "Baseline corr.: on\r\n";
	else
		*lpszHeader += "Baseline corr.: off\r\n";
		
	switch (nPlotMode)
	{
		case 0:
			*lpszHeader += "Plot mode: serial\r\n";
			break;
		case 1:
			*lpszHeader += "Plot mode: overlay\r\n";
			break;
		case 2:
			*lpszHeader += "Plot mode: off\r\n";
			break;
	}

	sprintf(buffer, "Plot size: %i cm\r\n", nPlotSize);
	*lpszHeader += buffer;
	
	switch (nPlotX)
	{
		case 0:
			*lpszHeader += "X axis incr.: 100\r\n";
			break;
		case 1:
			*lpszHeader += "X axis incr.: 50\r\n";
			break;
		case 2:
			*lpszHeader += "X axis incr.: 20\r\n";
			break;
		case 3:
			*lpszHeader += "X axis incr.: 10\r\n";
			break;
		case 4:
			*lpszHeader += "X axis incr.: 5\r\n";
			break;
		case 5:
			*lpszHeader += "X axis incr.: 2.5\r\n";
			break;
		case 6:
			*lpszHeader += "X axis incr.: 1\r\n";
			break;
		case 7:
			*lpszHeader += "X axis incr.: off\r\n";
			break;
	}
	
	switch (nPlotY)
	{
		case 0:
			*lpszHeader += "Y axis incr.: 1\r\n";
			break;
		case 1:
			*lpszHeader += "Y axis incr.: 0.5\r\n";
			break;
		case 2:
			*lpszHeader += "Y axis incr.: 0.1\r\n";
			break;
		case 3:
			*lpszHeader += "Y axis incr.: 0.05\r\n";
			break;
		case 4:
			*lpszHeader += "Y axis incr.: 0.01\r\n";
			break;
		case 5:
			*lpszHeader += "Y axis incr.: 0.005\r\n";
			break;
		case 6:
			*lpszHeader += "Y axis incr.: off\r\n";
	}
	
	// let base class write its data
	CMethodData::WriteMethodsHeader(lpszHeader);
	
}

///////////////////////////////////////////////////////////////////////////////
// SetDefault(): Sets default values for method parameters
///////////////////////////////////////////////////////////////////////////////
void CScanData::SetDefault()
{
	bBaseline = FALSE;
	nPlotMode = 2;
	nPlotSize = 20;
	nPlotX = 7;
	nPlotY = 6;
	nScanSpeed = 3;
	nXAxisMax = 700;
	nXAxisMin = 300;
	fYAxisMax = 2;
	fYAxisMin = 0;
	nInterval = 1;
	
	CMethodData::SetDefault();
}

/////////////////////////////////////////////////////////////////////////////////////
// Serialize(): Serializes member variables into archive
// Argument: archive: reference to CArchive
/////////////////////////////////////////////////////////////////////////////////////
void CScanData::Serialize(CArchive& archive)
{
	// call base class routine
	CMethodData::Serialize(archive);
	
	if (archive.IsStoring())
	{
		archive.Write(&bBaseline, sizeof(bBaseline));
		archive.Write(&nPlotMode, sizeof(nPlotMode));
		archive.Write(&nPlotSize, sizeof(nPlotSize));
		archive.Write(&nPlotX, sizeof(nPlotX));
		archive.Write(&nPlotY, sizeof(nPlotY));
		archive.Write(&nScanSpeed, sizeof(nScanSpeed));
		archive.Write(&nXAxisMax, sizeof(nXAxisMax));
		archive.Write(&nXAxisMin, sizeof(nXAxisMin));
		archive.Write(&fYAxisMax, sizeof(fYAxisMax));
		archive.Write(&fYAxisMin, sizeof(fYAxisMin));
		archive.Write(&nInterval, sizeof(nInterval));
	}
	else
	{
		archive.Read(&bBaseline, sizeof(bBaseline));
		archive.Read(&nPlotMode, sizeof(nPlotMode));
		archive.Read(&nPlotSize, sizeof(nPlotSize));
		archive.Read(&nPlotX, sizeof(nPlotX));
		archive.Read(&nPlotY, sizeof(nPlotY));
		archive.Read(&nScanSpeed, sizeof(nScanSpeed));
		archive.Read(&nXAxisMax, sizeof(nXAxisMax));
		archive.Read(&nXAxisMin, sizeof(nXAxisMin));
		archive.Read(&fYAxisMax, sizeof(fYAxisMax));
		archive.Read(&fYAxisMin, sizeof(fYAxisMin));
		archive.Read(&nInterval, sizeof(nInterval));
	}
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
// Class CFixData: Implementation
IMPLEMENT_SERIAL(CFixData, CMethodData, 1)

////////////////////////////////////////////////////////////////////////////////////////////
// WriteMethodsHeader(): Writes header to string
// Argument: lpszHeader: ptr to string which will hold header
////////////////////////////////////////////////////////////////////////////////////////////
void CFixData::WriteMethodsHeader(CString* lpszHeader)
{
	char buffer[50];
	
	*lpszHeader += "Lambda fix\r\n";
	
	if (bPlotMode)
	{
		*lpszHeader += "Plotter mode: on\r\n";
	}
	else
	{
		*lpszHeader += "Plotter mode: off\r\n";
	}
	
	sprintf(buffer, "Concentration factor: %.3f\r\n", fConcFactor);
	*lpszHeader += buffer;
	
	sprintf(buffer, "Integration time: %i\r\n", nIntegrationTime);
	*lpszHeader += buffer;
	
	sprintf(buffer, "Standard concentration: %.3f\r\n", fStandardConc);
	*lpszHeader += buffer;
	
	switch (nUnit)
	{
		case 0:
			*lpszHeader += "Unit: g\r\n";
			break;
		case 1:
			*lpszHeader += "Unit: mg\r\n";
			break;
		case 2:
			*lpszHeader += "Unit: g\r\n";
			break;
		case 3:
			*lpszHeader += "Unit: mol\r\n";
			break;
		case 4:
			*lpszHeader += "Unit: mmol\r\n";
			break;
		case 5:
			*lpszHeader += "Unit: mol\r\n";
			break;
		case 6:
			*lpszHeader += "Unit: off\r\n";
			break;
	}
	
	sprintf(buffer, "Wavelength: %i\r\n", nWavelength);
	*lpszHeader += buffer;
	
	
	// let base class write its data
	CMethodData::WriteMethodsHeader(lpszHeader);
	
}

/////////////////////////////////////////////////////////////////////////////////////
// Serialize(): Serializes member variables into archive
// Argument: archive: reference to CArchive
/////////////////////////////////////////////////////////////////////////////////////
void CFixData::Serialize(CArchive& archive)
{
	// call base class routine
	CMethodData::Serialize(archive);
	
	if (archive.IsStoring())
	{
		archive.Write(&bPlotMode, sizeof(bPlotMode));
		archive.Write(&fConcFactor, sizeof(fConcFactor));
		archive.Write(&nIntegrationTime, sizeof(nIntegrationTime));
		archive.Write(&fStandardConc, sizeof(fStandardConc));
		archive.Write(&nUnit, sizeof(nUnit));
		archive.Write(&nWavelength, sizeof(nWavelength));
	}
	else
	{
		archive.Read(&bPlotMode, sizeof(bPlotMode));
		archive.Read(&fConcFactor, sizeof(fConcFactor));
		archive.Read(&nIntegrationTime, sizeof(nIntegrationTime));
		archive.Read(&fStandardConc, sizeof(fStandardConc));
		archive.Read(&nUnit, sizeof(nUnit));
		archive.Read(&nWavelength, sizeof(nWavelength));
	}
}

///////////////////////////////////////////////////////////////////////////////
// SetDefault(): Sets default values for method parameters
///////////////////////////////////////////////////////////////////////////////
void CFixData::SetDefault()
{
	fConcFactor = 1;
	nIntegrationTime = 1;
	bPlotMode = FALSE;
	fStandardConc = 1;
	nUnit = 6;
	nWavelength = 540;
	
	CMethodData::SetDefault();
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
// Class CDriveData: Implementation
IMPLEMENT_SERIAL(CDriveData, CMethodData, 1)

////////////////////////////////////////////////////////////////////////////////////////////
// WriteMethodsHeader(): Writes header to string
// Argument: lpszHeader: ptr to string which will hold header
////////////////////////////////////////////////////////////////////////////////////////////
void CDriveData::WriteMethodsHeader(CString* lpszHeader)
{
	char buffer[50];
	
	*lpszHeader += "Time drive\r\n";
	
	if (nAbsMode == 1)
		*lpszHeader += "Mode: abs\r\n";
	else
		*lpszHeader += "Mode: %T\r\n";
		
	sprintf(buffer, "Y axis min*max: %.3f*%.3f\r\n", fYAxisMin, fYAxisMax);
	*lpszHeader += buffer;
	
	switch (nSamplingRate)
	{
		case 0:
			*lpszHeader += "Sampling rate: 1000/min\r\n";
			break;
		case 1:
			*lpszHeader += "Sampling rate: 600/min\r\n";
			break;
		case 2:
			*lpszHeader += "Sampling rate: 120/min\r\n";
			break;
		case 3:
			*lpszHeader += "Sampling rate: 60/min\r\n";
			break;
		case 4:
			*lpszHeader += "Sampling rate: 10/min\r\n";
			break;
		case 5:
			*lpszHeader += "Sampling rate: 1/min\r\n";
			break;
	}

	sprintf(buffer, "Measurement time: %.1f\r\n", fMeasureTime);
	*lpszHeader += buffer;
	
	switch (nPlotMode)
	{
		case 0:
			*lpszHeader += "Plot mode: serial\r\n";
			break;
		case 1:
			*lpszHeader += "Plot mode: overlay\r\n";
			break;
		case 2:
			*lpszHeader += "Plot mode: off\r\n";
			break;
	}

	sprintf(buffer, "Plot size: %i cm\r\n", nPlotSize);
	*lpszHeader += buffer;
	
	switch (nPlotX)
	{
		case 0:
			*lpszHeader += "X axis incr.: 100\r\n";
			break;
		case 1:
			*lpszHeader += "X axis incr.: 50\r\n";
			break;
		case 2:
			*lpszHeader += "X axis incr.: 20\r\n";
			break;
		case 3:
			*lpszHeader += "X axis incr.: 10\r\n";
			break;
		case 4:
			*lpszHeader += "X axis incr.: 5\r\n";
			break;
		case 5:
			*lpszHeader += "X axis incr.: 2.5\r\n";
			break;
		case 6:
			*lpszHeader += "X axis incr.: 1\r\n";
			break;
		case 7:
			*lpszHeader += "X axis incr.: off\r\n";
			break;
	}
	
	switch (nPlotY)
	{
		case 0:
			*lpszHeader += "Y axis incr.: 1\r\n";
			break;
		case 1:
			*lpszHeader += "Y axis incr.: 0.5\r\n";
			break;
		case 2:
			*lpszHeader += "Y axis incr.: 0.1\r\n";
			break;
		case 3:
			*lpszHeader += "Y axis incr.: 0.05\r\n";
			break;
		case 4:
			*lpszHeader += "Y axis incr.: 0.01\r\n";
			break;
		case 5:
			*lpszHeader += "Y axis incr.: 0.005\r\n";
			break;
		case 6:
			*lpszHeader += "Y axis incr.: off\r\n";
	}
	
	// let base class write its data
	CMethodData::WriteMethodsHeader(lpszHeader);
	
}

///////////////////////////////////////////////////////////////////////////////
// SetDefault(): Sets default values for method parameters
///////////////////////////////////////////////////////////////////////////////
void CDriveData::SetDefault()
{
	nPlotMode = 2;
	nPlotSize = 20;
	nPlotX = 7;
	nPlotY = 6;
	fYAxisMax = 2;
	fYAxisMin = 0;
	nWavelength = 540;
	nSamplingRate = 3;
	fMeasureTime = 10;
	
	
	CMethodData::SetDefault();
}

/////////////////////////////////////////////////////////////////////////////////////
// Serialize(): Serializes member variables into archive
// Argument: archive: reference to CArchive
/////////////////////////////////////////////////////////////////////////////////////
void CDriveData::Serialize(CArchive& archive)
{
	// call base class routine
	CMethodData::Serialize(archive);
	
	if (archive.IsStoring())
	{
		archive.Write(&nPlotMode, sizeof(nPlotMode));
		archive.Write(&nPlotSize, sizeof(nPlotSize));
		archive.Write(&nPlotX, sizeof(nPlotX));
		archive.Write(&nPlotY, sizeof(nPlotY));
		archive.Write(&fYAxisMax, sizeof(fYAxisMax));
		archive.Write(&fYAxisMin, sizeof(fYAxisMin));
		archive.Write(&nWavelength, sizeof(nWavelength));
		archive.Write(&nSamplingRate, sizeof(nSamplingRate));
		archive.Write(&fMeasureTime, sizeof(fMeasureTime));
	}
	else
	{
		archive.Read(&nPlotMode, sizeof(nPlotMode));
		archive.Read(&nPlotSize, sizeof(nPlotSize));
		archive.Read(&nPlotX, sizeof(nPlotX));
		archive.Read(&nPlotY, sizeof(nPlotY));
		archive.Read(&fYAxisMax, sizeof(fYAxisMax));
		archive.Read(&fYAxisMin, sizeof(fYAxisMin));
		archive.Read(&nWavelength, sizeof(nWavelength));
		archive.Read(&nSamplingRate, sizeof(nSamplingRate));
		archive.Read(&fMeasureTime, sizeof(fMeasureTime));
	}
}
