// mainfrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "uvikon.h"

#include "mainfrm.h"
#include <shellapi.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	ON_WM_COMPACTING()
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_WININICHANGE()
	ON_WM_DROPFILES()
	//}}AFX_MSG_MAP
	// Global help commands
	ON_COMMAND(ID_HELP_INDEX, CMDIFrameWnd::OnHelpIndex)
	ON_COMMAND(ID_HELP_USING, CMDIFrameWnd::OnHelpUsing)
	ON_COMMAND(ID_HELP, CMDIFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CMDIFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CMDIFrameWnd::OnHelpIndex)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// arrays of IDs used to initialize control bars

// toolbar buttons - IDs are command buttons
static UINT BASED_CODE buttons[] =
{
	// same order as in the bitmap 'toolbar.bmp'
	ID_FILE_NEW,
	ID_FILE_OPEN,
	ID_FILE_SAVE,
		ID_SEPARATOR,
	ID_EDIT_CUT,
	ID_EDIT_COPY,
	ID_EDIT_PASTE,
		ID_SEPARATOR,
	ID_FILE_CONNECT,
	ID_FILE_DISCONNECT,
		ID_SEPARATOR,
	ID_RUN_RUNSAMPLE,
	ID_RUN_RUNBASELINE,
		ID_SEPARATOR,
	ID_METHODS_DEFAULT,
	ID_METHODS_LAMBDASCAN,
	ID_METHODS_LAMBDAFIX,
	ID_METHODS_TIMEDRIVE,
		ID_SEPARATOR,
	ID_APP_ABOUT,
	ID_CONTEXT_HELP,
};

static UINT BASED_CODE indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_SEPARATOR,			// file size indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	UINT nID, nStyle;
	int cxWidth;

	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadBitmap(IDR_MAINFRAME) ||
		!m_wndToolBar.SetButtons(buttons,
		  sizeof(buttons)/sizeof(UINT)))
	{
		TRACE("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE("Failed to create status bar\n");
		return -1;      // fail to create
	}
	
	m_wndStatusBar.GetPaneInfo(1, nID, nStyle, cxWidth);
	m_wndStatusBar.SetPaneInfo(1, nID, nStyle, 70);      // Set new width

	DragAcceptFiles(TRUE);    // we're a drag&drop target
	
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

/////////////////////////////////////////////////////////////////////////////
// OnWinIniChange(): Invoked after win.ini changed. We read this message to
//                   look for changes in the intl settings
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWinIniChange(LPCSTR lpszSection)
{
	CMDIFrameWnd::OnWinIniChange(lpszSection);
	
	((CUvikonApp*)AfxGetApp())->ReadWinIni();
	
}

//////////////////////////////////////////////////////////////////////////////
// OnCompacting(): Called when memory is low. We read this message to free 
//                 allocated memory from document arrays
//////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnCompacting(UINT nCpuTime)
{
	SendMessageToDescendants(WM_LOWMEM, 0, 0, TRUE, FALSE);
}

/////////////////////////////////////////////////////////////////////////////////
// UpdateStatusLine(): Updates status line texts in panes 1-3
// Arguments: nID: zero-based ID of pane
//            PaneText: ptr to new text of pane
/////////////////////////////////////////////////////////////////////////////////	
void CMainFrame::UpdateStatusLine(UINT nID, LPSTR szPaneText)
{
	m_wndStatusBar.SetPaneText(nID, szPaneText, TRUE);
	
}

/////////////////////////////////////////////////////////////////////////////////
// OnDropFiles(): Handler for WM_DROPFILES message
/////////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnDropFiles(HDROP hDropInfo)
{
	UINT numFiles, i;
	char szFileName[260];
	CUvikonApp* pApp = (CUvikonApp*)AfxGetApp();
	
	numFiles = DragQueryFile(hDropInfo, -1, NULL, 0);     // get number of dropped files
	
	for (i = 0; i < numFiles; i++)                        // cycle thru dropped files
	{
		DragQueryFile(hDropInfo, i, szFileName, sizeof(szFileName)); // get path+name
		pApp->OpenDocumentFile(szFileName);	                         // and open it
	}                     // NB: MFC simply ignores a file which is not in the proper format
	
	DragFinish(hDropInfo);     // we're done, free memory
}
