// lscandlg.cpp : implementation file
//

#include "stdafx.h"
#include "uvikon.h"
#include "lscandlg.h"
#include "comfns.h"

#include <afx.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

static char szFilter[] = "Lambda scan (*.scn)|*.scn | All Files (*.*)|*.*||";
/////////////////////////////////////////////////////////////////////////////
// CLScanDlg dialog


CLScanDlg::CLScanDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLScanDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLScanDlg)
	m_bBaseline = FALSE;
	m_bDoubleBeam = TRUE;
	m_nCycleNumber = 1;
	m_bDLamp = TRUE;
	m_bHLamp = TRUE;
	m_nLampChange = 340;
	m_nAbsMode = 0;
	m_nPlotMode = 2;
	m_nPlotSize = 20;
	m_nPlotX = 7;
	m_nPlotY = 6;
	m_nScanSpeed = 3;
	m_nXAxisMax = 700;
	m_nXAxisMin = 300;
	m_fYAxisMax = 2;
	m_fYAxisMin = 0;
	m_nLampBandwidth = 1;
	m_nInterval = 1;
	m_fCycleTime = 0;
	m_bSendAll = FALSE;
	//}}AFX_DATA_INIT
}

void CLScanDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLScanDlg)
	DDX_Check(pDX, IDC_BASELINE, m_bBaseline);
	DDX_Check(pDX, IDC_BEAM, m_bDoubleBeam);
	DDX_Text(pDX, IDC_CYCLENUM, m_nCycleNumber);
	DDV_MinMaxInt(pDX, m_nCycleNumber, 1, 99);
	DDX_Check(pDX, IDC_DLAMP, m_bDLamp);
	DDX_Check(pDX, IDC_HLAMP, m_bHLamp);
	DDX_Text(pDX, IDC_LAMPCHANGE, m_nLampChange);
	DDX_Radio(pDX, IDC_MODE1, m_nAbsMode);
	DDX_CBIndex(pDX, IDC_PLOTMODE, m_nPlotMode);
	DDX_Text(pDX, IDC_PLOTSIZE, m_nPlotSize);
	DDV_MinMaxInt(pDX, m_nPlotSize, 5, 150);
	DDX_CBIndex(pDX, IDC_PLOTX, m_nPlotX);
	DDX_CBIndex(pDX, IDC_PLOTY, m_nPlotY);
	DDX_CBIndex(pDX, IDC_SPEED, m_nScanSpeed);
	DDX_Text(pDX, IDC_XAXISMAX, m_nXAxisMax);
	DDV_MinMaxInt(pDX, m_nXAxisMax, 180, 900);
	DDX_Text(pDX, IDC_XAXISMIN, m_nXAxisMin);
	DDV_MinMaxInt(pDX, m_nXAxisMin, 180, 900);
	DDX_Text(pDX, IDC_YAXISMAX, m_fYAxisMax);
	DDV_MinMaxFloat(pDX, m_fYAxisMax, -0.3, 4.);
	DDX_Text(pDX, IDC_YAXISMIN, m_fYAxisMin);
	DDV_MinMaxFloat(pDX, m_fYAxisMin, -0.3, 4.);
	DDX_CBIndex(pDX, IDC_BANDWIDTH, m_nLampBandwidth);
	DDX_CBIndex(pDX, IDC_INTERVAL, m_nInterval);
	DDX_Text(pDX, IDC_CYCLETIME, m_fCycleTime);
	DDV_MinMaxFloat(pDX, m_fCycleTime, 0.1, 9999.);
	DDX_Check(pDX, IDC_SENDALL, m_bSendAll);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLScanDlg, CDialog)
	//{{AFX_MSG_MAP(CLScanDlg)
	ON_BN_CLICKED(IDC_LOADMETHOD, OnLoadmethod)
	ON_BN_CLICKED(IDC_SAVEMETHOD, OnSavemethod)
	ON_BN_CLICKED(IDC_DEFAULT, OnDefault)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLScanDlg message handlers

BOOL CLScanDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	::CenterWindow(GetParent(), this);    // center dialog in frame window
	
	// initialize m_ScanData member
	FillMembers(TRUE);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////////////////
// OnLoadmethod(): Handler for the Load method button
/////////////////////////////////////////////////////////////////////////////////////////
void CLScanDlg::OnLoadmethod()
{
	CFileDialog dlg(TRUE, ".scn", NULL, OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT, szFilter);
	
	if (dlg.DoModal() == IDOK)
	{
		CFile theFile;
		theFile.Open(dlg.GetPathName(), CFile::shareDenyWrite|CFile::modeRead);
		CArchive archive(&theFile, CArchive::load);
		m_ScanData.Serialize(archive);
		archive.Close();
		theFile.Close();
		
		FillMembers(FALSE);		// copy m_ScanData values to member variables
		UpdateData(FALSE);
	}
	
}

/////////////////////////////////////////////////////////////////////////////////////////
// OnSavemethod(): Handler for the Save method button
/////////////////////////////////////////////////////////////////////////////////////////
void CLScanDlg::OnSavemethod()
{
	CFileDialog dlg(FALSE, ".scn", NULL, OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT, szFilter);
	
	if (dlg.DoModal() == IDOK)
	{
		UpdateData(TRUE);
		FillMembers(TRUE);
		
		CFile theFile;
		theFile.Open(dlg.GetPathName(), CFile::shareDenyWrite|CFile::modeCreate|CFile::modeWrite);
		CArchive archive(&theFile, CArchive::store);
		m_ScanData.Serialize(archive);
		archive.Close();
		theFile.Close();
	}
}

//////////////////////////////////////////////////////////////////////////////
// OnDefault(): Handler for Default button. Sets instrument default values
//////////////////////////////////////////////////////////////////////////////
void CLScanDlg::OnDefault()
{
	m_ScanData.SetDefault();
	FillMembers(FALSE);
	UpdateData(FALSE);
}

///////////////////////////////////////////////////////////////////////////////
// FillMembers(): Fills member variables
// Argument: set: if TRUE, m_ScanData is updated from member variables
//                if FALSE, member variables are updated from m_ScanData
///////////////////////////////////////////////////////////////////////////////
void CLScanDlg::FillMembers(BOOL set)
{
	if (set)
	{
		m_ScanData.bBaseline = m_bBaseline;
		m_ScanData.bDoubleBeam = m_bDoubleBeam;
		m_ScanData.nCycleNumber = m_nCycleNumber;
		m_ScanData.bDLamp = m_bDLamp;
		m_ScanData.bHLamp = m_bHLamp;
		m_ScanData.nLampChange = m_nLampChange;
		m_ScanData.nAbsMode = m_nAbsMode;
		m_ScanData.nPlotMode = m_nPlotMode;
		m_ScanData.nPlotSize = m_nPlotSize;
		m_ScanData.nPlotX = m_nPlotX;
		m_ScanData.nPlotY = m_nPlotY;
		m_ScanData.nScanSpeed = m_nScanSpeed;
		m_ScanData.nXAxisMax = m_nXAxisMax;
		m_ScanData.nXAxisMin = m_nXAxisMin;
		m_ScanData.fYAxisMax = m_fYAxisMax;
		m_ScanData.fYAxisMin = m_fYAxisMin;
		m_ScanData.nLampBandwidth = m_nLampBandwidth;
		m_ScanData.nInterval = m_nInterval;
		m_ScanData.fCycleTime = m_fCycleTime;
	}
	else
	{
		m_bBaseline = m_ScanData.bBaseline;
		m_bDoubleBeam = m_ScanData.bDoubleBeam;
		m_nCycleNumber = m_ScanData.nCycleNumber;
		m_bDLamp = m_ScanData.bDLamp;
		m_bHLamp = m_ScanData.bHLamp;
		m_nLampChange = m_ScanData.nLampChange;
		m_nAbsMode = m_ScanData.nAbsMode;
		m_nPlotMode = m_ScanData.nPlotMode;
		m_nPlotSize = m_ScanData.nPlotSize;
		m_nPlotX = m_ScanData.nPlotX;
		m_nPlotY = m_ScanData.nPlotY;
		m_nScanSpeed = m_ScanData.nScanSpeed;
		m_nXAxisMax = m_ScanData.nXAxisMax;
		m_nXAxisMin = m_ScanData.nXAxisMin;
		m_fYAxisMax = m_ScanData.fYAxisMax;
		m_fYAxisMin = m_ScanData.fYAxisMin;
		m_nLampBandwidth = m_ScanData.nLampBandwidth;
		m_nInterval = m_ScanData.nInterval;
		m_fCycleTime = m_ScanData.fCycleTime;
	}
}
		
