// listview.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CListView scroll view

class CListView : public CScrollView
{
	DECLARE_DYNCREATE(CListView)
protected:
	CListView();			// protected constructor used by dynamic creation

// Attributes
	TEXTMETRIC m_tm;			// struct holding info about font metrics
	int m_nPrevLine;			// for mouse move: previously selected line
	int m_nAnchorLine;			// anchor for multiple selection
	BOOL m_bShiftPressed;		// indicates whether shift key is pressed
	
// Operations
public:
    
protected:
	void DrawIcon(int nType, CDC* pDC, int nLine);
	void TitleEdit(int nLine);
	void ScrollIntoVis(int nLine);
	
// Implementation
public:
	virtual void OnInitialUpdate();
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);

protected:
	virtual ~CListView();
	// Generated message map functions
	//{{AFX_MSG(CListView)
	afx_msg void OnEditClear();
	afx_msg void OnUpdateEditClear(CCmdUI* pCmdUI);
	afx_msg void OnEditClearAll();
	afx_msg void OnUpdateEditClearAll(CCmdUI* pCmdUI);
	afx_msg void OnEditCopy();
	afx_msg void OnUpdateEditCopy(CCmdUI* pCmdUI);
	afx_msg void OnEditCut();
	afx_msg void OnUpdateEditCut(CCmdUI* pCmdUI);
	afx_msg void OnEditPaste();
	afx_msg void OnUpdateEditPaste(CCmdUI* pCmdUI);
	afx_msg void OnEditUndo();
	afx_msg void OnUpdateEditUndo(CCmdUI* pCmdUI);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
