// lfixdlg.cpp : implementation file
//

#include "stdafx.h"
#include "uvikon.h"
#include "lfixdlg.h"
#include "comfns.h"

#include <afx.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

static char szFilter[] = "Lambda fix (*.fix)|*.fix | All Files (*.*)|*.*||";
/////////////////////////////////////////////////////////////////////////////
// CLFixDlg dialog


CLFixDlg::CLFixDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLFixDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLFixDlg)
	m_nLampBandwidth = 1;
	m_bDoubleBeam = TRUE;
	m_fConcFactor = 1;
	m_nCycleNumber = 1;
	m_fCycleTime = 0.1;
	m_bDLamp = TRUE;
	m_bHLamp = TRUE;
	m_nIntegrationTime = 1;
	m_nLampChange = 340;
	m_nAbsMode = 0;
	m_bPlotMode = FALSE;
	m_fStandardConc = 1;
	m_nUnit = 6;
	m_nWavelength = 540;
	m_bSendAll = FALSE;
	//}}AFX_DATA_INIT
}

void CLFixDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLFixDlg)
	DDX_CBIndex(pDX, IDC_BANDWIDTH, m_nLampBandwidth);
	DDX_Check(pDX, IDC_BEAM, m_bDoubleBeam);
	DDX_Text(pDX, IDC_CONCFACTOR, m_fConcFactor);
	DDV_MinMaxFloat(pDX, m_fConcFactor, 1.e-003, 9999.);
	DDX_Text(pDX, IDC_CYCLENUM, m_nCycleNumber);
	DDV_MinMaxInt(pDX, m_nCycleNumber, 1, 99);
	DDX_Text(pDX, IDC_CYCLETIME, m_fCycleTime);
	DDV_MinMaxFloat(pDX, m_fCycleTime, 0.1, 9999.9);
	DDX_Check(pDX, IDC_DLAMP, m_bDLamp);
	DDX_Check(pDX, IDC_HLAMP, m_bHLamp);
	DDX_Text(pDX, IDC_INTEGTIME, m_nIntegrationTime);
	DDV_MinMaxInt(pDX, m_nIntegrationTime, 1, 60);
	DDX_Text(pDX, IDC_LAMPCHANGE, m_nLampChange);
	DDV_MinMaxInt(pDX, m_nLampChange, 290, 400);
	DDX_CBIndex(pDX, IDC_MODE, m_nAbsMode);
	DDX_Check(pDX, IDC_PLOTTER, m_bPlotMode);
	DDX_Text(pDX, IDC_STANDARDCONC, m_fStandardConc);
	DDV_MinMaxFloat(pDX, m_fStandardConc, 1.e-003, 9999.);
	DDX_CBIndex(pDX, IDC_UNIT, m_nUnit);
	DDX_Text(pDX, IDC_WAVELENGTH, m_nWavelength);
	DDV_MinMaxInt(pDX, m_nWavelength, 180, 900);
	DDX_Check(pDX, IDC_SENDALL, m_bSendAll);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLFixDlg, CDialog)
	//{{AFX_MSG_MAP(CLFixDlg)
	ON_BN_CLICKED(IDC_LOADMETHOD, OnLoadmethod)
	ON_BN_CLICKED(IDC_SAVEMETHOD, OnSavemethod)
	ON_BN_CLICKED(IDC_DEFAULT, OnDefault)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLFixDlg message handlers

BOOL CLFixDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	::CenterWindow(GetParent(), this);    // center dialog in frame window
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////////////////
// OnLoadmethod(): Handler for the Load method button
/////////////////////////////////////////////////////////////////////////////////////////
void CLFixDlg::OnLoadmethod()
{
	CFileDialog dlg(TRUE, ".fix", NULL, OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT, szFilter);
	
	if (dlg.DoModal() == IDOK)
	{
		CFile theFile;
		theFile.Open(dlg.GetPathName(), CFile::shareDenyWrite|CFile::modeRead);
		CArchive archive(&theFile, CArchive::load);
		m_FixData.Serialize(archive);
		archive.Close();
		theFile.Close();
		
		FillMembers(FALSE);		// copy m_FixData values to member variables
		UpdateData(FALSE);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////
// OnSavemethod(): Handler for the Save method button
/////////////////////////////////////////////////////////////////////////////////////////
void CLFixDlg::OnSavemethod()
{
	CFileDialog dlg(FALSE, ".fix", NULL, OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT, szFilter);
	
	if (dlg.DoModal() == IDOK)
	{
		UpdateData(TRUE);
		FillMembers(TRUE);
		
		CFile theFile;
		theFile.Open(dlg.GetPathName(), CFile::shareDenyWrite|CFile::modeCreate|CFile::modeWrite);
		CArchive archive(&theFile, CArchive::store);
		m_FixData.Serialize(archive);
		archive.Close();
		theFile.Close();
	}
}

//////////////////////////////////////////////////////////////////////////////
// OnDefault(): Handler for Default button. Sets instrument default values
//////////////////////////////////////////////////////////////////////////////
void CLFixDlg::OnDefault()
{
	m_FixData.SetDefault();
	FillMembers(FALSE);
	UpdateData(FALSE);
}

///////////////////////////////////////////////////////////////////////////////
// FillMembers(): Fills member variables
// Argument: set: if TRUE, m_ScanData is updated from member variables
//                if FALSE, member variables are updated from m_ScanData
///////////////////////////////////////////////////////////////////////////////
void CLFixDlg::FillMembers(BOOL set)
{
	if (set)
	{
		m_FixData.bDoubleBeam = m_bDoubleBeam;
		m_FixData.nCycleNumber = m_nCycleNumber;
		m_FixData.bDLamp = m_bDLamp;
		m_FixData.bHLamp = m_bHLamp;
		m_FixData.nLampChange = m_nLampChange;
		m_FixData.nAbsMode = m_nAbsMode;
		m_FixData.nLampBandwidth = m_nLampBandwidth;
		m_FixData.fCycleTime = m_fCycleTime;
		
		m_FixData.fConcFactor = m_fConcFactor;
		m_FixData.nIntegrationTime = m_nIntegrationTime;
		m_FixData.bPlotMode = m_bPlotMode;
		m_FixData.fStandardConc = m_fStandardConc;
		m_FixData.nUnit = m_nUnit;
		m_FixData.nWavelength = m_nWavelength;
	}
	else
	{
		m_bDoubleBeam = m_FixData.bDoubleBeam;
		m_nCycleNumber = m_FixData.nCycleNumber;
		m_bDLamp = m_FixData.bDLamp;
		m_bHLamp = m_FixData.bHLamp;
		m_nLampChange = m_FixData.nLampChange;
		m_nAbsMode = m_FixData.nAbsMode;
		m_nLampBandwidth = m_FixData.nLampBandwidth;
		m_fCycleTime = m_FixData.fCycleTime;

		m_fConcFactor = m_FixData.fConcFactor;
		m_nIntegrationTime = m_FixData.nIntegrationTime;
		m_bPlotMode = m_FixData.bPlotMode;
		m_fStandardConc = m_FixData.fStandardConc;
		m_nUnit = m_FixData.nUnit;
		m_nWavelength = m_FixData.nWavelength;
	}
}
		
