// source file for common functions

#include "stdafx.h"
///////////////////////////////////////////////////////////////////////////////
// CenterWindow(): centers the child window over the center of the parent
//
// void CenterWindow (CWnd* pWndP, CWnd* pWndC)
// Parameters: pWndP: Pointer to parent window
//             pWndC: Pointer to child window
// Returns: none
///////////////////////////////////////////////////////////////////////////////
void CenterWindow(CWnd* pWndP, CWnd* pWndC)     // parent window, child window
{
	CRect wnRectpar, wnRectspl;
	int xCenter, yCenter;
	
	pWndP->GetWindowRect(&wnRectpar);      // Get window position of parent
	xCenter = wnRectpar.left + (wnRectpar.Width()/2);  // calculate center in
	yCenter = wnRectpar.top + (wnRectpar.Height()/2);  // screen coordinates
	
	pWndC->GetWindowRect(&wnRectspl);        // Get window position of child
	
	wnRectpar.left = xCenter - (wnRectspl.Width()/2);   // adjust child window
	wnRectpar.right = wnRectpar.left + wnRectspl.Width();
	wnRectpar.top = yCenter - (wnRectspl.Height()/2);
	wnRectpar.bottom = wnRectpar.top + wnRectspl.Height();
	
	pWndC->MoveWindow(&wnRectpar, TRUE);     // move to new location with redraw switch set TRUE
}

