// tricadoc.h : interface of the CTricarbDoc class and support classes
//
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Hierarchy chart for support classes
//
// CDataLine
//   CTextType
//     CPlainLine
//     CExcelLine
//   CBinaryType
//     CMulticalcLine

struct MCData         // Multicalc data type
{
	short id1;           // id are placeholders which are zero in manual input files
	short linenumber;
	short id2;
	short id3;
	float cpma1;         // cpm channel a
	float cpmb1;         // cpm channel b
	float cpma2;         // same as cpm channel a
	float sqrtcpma2;     // square root of cpm channel a
	float cpmb2;         // same as cpm channel b
	float sqrtcpmb2;     // square root of cpm channel b
	short id4;
	short id5;
	short counttime;     // counting time
	short id6;
};

/////////////////////////////////////////////////////////////////////////////
// CDataLine: Base class for all types of output data lines
class CDataLine : public CObject
{
public:
	CDataLine();
	~CDataLine();
// Members
public:
	int m_nOutFormat;
// Interface
public:
	virtual BOOL MakeFileName(char* szFileName, char* szFullPath);
	virtual BOOL WriteHeaderToDisk(CString* pHeader, char* szFileName, int nTerm);
	virtual int WriteLineToDisk(CString* pString, char* szFileName);
protected:
	BOOL TestDirectory(char* szFileName);
};

/////////////////////////////////////////////////////////////////////////////
// CTextType: Base class for all types of text-based output data lines
class CTextType : public CDataLine
{
public:
	CTextType();
	~CTextType();
// Members
public:
	CString m_szDataLine;		// the string, public for access by derived classes
public:
	virtual BOOL MakeFileName(char* szFileName, char* szFullPath);
	virtual BOOL WriteHeaderToDisk(CString* pHeader, char* szFileName, int nTerm);
	//virtual BOOL WriteLineToDisk(CString* pString, char* szFileName);
};

/////////////////////////////////////////////////////////////////////////////
// CBinaryType: Base class for all types of binary output data lines
class CBinaryType : public CDataLine
{
public:
	CBinaryType();
	~CBinaryType();
public:
	virtual BOOL WriteHeaderToDisk(CString* pHeader, char* szFileName, int nTerm);
	//virtual BOOL WriteLineToDisk(CString* pString, char* szFileName);
};

/////////////////////////////////////////////////////////////////////////////
// CPlainLine: Plain output data line
class CPlainLine : public CTextType
{
public:
	CPlainLine();
	~CPlainLine();
public:
	//virtual BOOL MakeFileName(char* szFileName, char* szFullPath);
	//virtual void WriteHeaderToDisk(CString* pHeader, char* szFileName, int nTerm);
	virtual int WriteLineToDisk(CString* pString, char* szFileName);
};

/////////////////////////////////////////////////////////////////////////////
// CExcelLine: Excel output data line
class CExcelLine : public CTextType
{
public:
	CExcelLine();
	~CExcelLine();
public:
	//virtual BOOL MakeFileName(char* szFileName, char* szFullPath);
	//virtual void WriteHeaderToDisk(CString* pHeader, char* szFileName, int nTerm);
	virtual int WriteLineToDisk(CString* pString, char* szFileName);
};

/////////////////////////////////////////////////////////////////////////////
// CMulticalcLine: Multicalc output data line
class CMulticalcLine : public CBinaryType
{
public:
	CMulticalcLine(int channels);
	~CMulticalcLine();
// Members
private:
	MCData m_OutData;	        // structure holding output data
	BOOL m_bDual;				// TRUE if dual channel, FALSE if single channel
// Operations
protected:
	void AutoFill();
// Interface
public:
	virtual BOOL MakeFileName(char* szFileName, char* szFullPath);
	//virtual void WriteHeaderToDisk(CString* pHeader, char* szFileName, int nTerm);
	virtual int WriteLineToDisk(CString* pString, char* szFileName);
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// CTricarbDoc
class CTricarbDoc : public CDocument
{
protected: // create from serialization only
	CTricarbDoc();
	DECLARE_DYNCREATE(CTricarbDoc)

// Attributes
public:
protected:
	CDWordArray m_LineArray;	// Array holding CStrings which correspond to one line of data
	char m_szFileName[260];     // full path of saveto file
	CSize m_sizeDoc;            // size of document (used for scrolling)
	int m_nProgramNo;           // number of counter program
	int m_nOutFormat;           // number of output format
	BOOL m_bRecover;		    // TRUE if powerfail recovery file, FALSE if not
	BOOL m_bIsFirstLine;        // TRUE if first line in file, FALSE if not
	CDataLine* m_pDataLine;     // ptr to CDataLine object
// Operations
public:
    CString* NewLine();                       // adds a new line to the array
    void SaveLine(CString* pString);          // writes new line to disk
    CSize GetDocSize() {return m_sizeDoc;}    // helper for accessing protected doc size
    void SetDocSize(CSize docsize);           // set new document size
    int GetNumLines();                        // retrieve the number of lines in the array
    CString* GetLine(int index);              // retrieve the CString at the given position
    void ReportError(int event, char* szError);  // reports COM error to log file
protected:
	void ReformatScreenString(CString* pstring); // reformats the CString to the desired output format
	BOOL MakeFileName(CString* pstring);      // gets an unique filename
// Implementation
public:
	virtual ~CTricarbDoc();
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	virtual BOOL OnNewDocument();
	virtual BOOL CanCloseFrame(CFrameWnd* pFrame);

// Generated message map functions
protected:
	//{{AFX_MSG(CTricarbDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
