// tricavw.cpp : implementation of the CTricarbView class
//

#include <afx.h>
#include <windows.h>
#include <math.h>
#include "stdafx.h"
#include "tricarb.h"

#include "tricadoc.h"
#include "tricavw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTricarbView

IMPLEMENT_DYNCREATE(CTricarbView, CScrollView)

BEGIN_MESSAGE_MAP(CTricarbView, CScrollView)
	//{{AFX_MSG_MAP(CTricarbView)
	ON_MESSAGE(WM_COMMNOTIFY, OnCommNotify)
	ON_COMMAND(ID_OPTIONS_NEWSTRING, OnOptionsNewstring)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTricarbView construction/destruction

CTricarbView::CTricarbView()
{
	// TODO: add construction code here
}

CTricarbView::~CTricarbView()
{
}

/////////////////////////////////////////////////////////////////////////////
// CTricarbView drawing

/////////////////////////////////////////////////////////////////////////////
// OnDraw(): Called when view must render an image of the document
// Arguments: pDC: ptr to device context
/////////////////////////////////////////////////////////////////////////////
void CTricarbView::OnDraw(CDC* pDC)
{
	int i;
	CFont* pOldFont;
	CSize actualSize, maxSize;
	TEXTMETRIC tm;
	int nlineSpace = 2;
	int nleftMargin = 5;
	int nrightMargin = 5;
	int ncharWidths[10];
	int ntabPosition[10];
	POINT upperleft;
	
	CTricarbDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	maxSize = pDoc->GetDocSize();   // get old size of document
	pOldFont = (CFont*)pDC->SelectStockObject(/*ANSI_FIXED_FONT`*/SYSTEM_FONT);  // select font
	pDC->GetTextMetrics(&tm);       // get information about font
	pDC->GetOutputCharWidth((UINT)'0', (UINT)'9', ncharWidths);
	
	// set tab positions
	ntabPosition[0] = nleftMargin + (3*ncharWidths[0]);     // allow for 2-digit protocol#
	ntabPosition[1] = ntabPosition[0] + (4*ncharWidths[0]); // allow for 3-digit rack#
	ntabPosition[2] = ntabPosition[1] + (5*ncharWidths[0]); // allow for 4-digit sample#
	ntabPosition[3] = ntabPosition[2] + (6*ncharWidths[0]); // allow for 5-digit counting time
	ntabPosition[4] = ntabPosition[3] + (12*ncharWidths[0]); // allow for 11-digit value
	ntabPosition[5] = ntabPosition[4] + (12*ncharWidths[0]); // allow for 11-digit value
	ntabPosition[6] = ntabPosition[5] + (12*ncharWidths[0]); // allow for 11-digit value
	ntabPosition[7] = ntabPosition[6] + (12*ncharWidths[0]); // allow for 11-digit value
	ntabPosition[8] = ntabPosition[7] + (12*ncharWidths[0]); // allow for 11-digit value
	ntabPosition[9] = ntabPosition[8] + (12*ncharWidths[0]); // allow for 11-digit value
	
	for (i = 0; i < pDoc->GetNumLines(); i++)    // run thru all lines
	{
		actualSize = pDC->TabbedTextOut(nleftMargin, i*tm.tmHeight + nlineSpace, *(pDoc->GetLine(i)), (pDoc->GetLine(i))->GetLength(), 10, ntabPosition, 0);
		if (actualSize.cx + nleftMargin + nrightMargin > maxSize.cx)
		{
			maxSize.cx = actualSize.cx + nleftMargin + nrightMargin;	// set new width of document
		}
	}
	
	if ((i+1)*tm.tmHeight + nlineSpace > maxSize.cy)
	{
		maxSize.cy = (i+1)*tm.tmHeight + nlineSpace;    // set new height of document
	}
	
	// Set newly calculated document size
	pDoc->SetDocSize(maxSize);
	SetScrollSizes(MM_TEXT, maxSize);  // update scrolling
	
	// scroll to origin if it's a new doc
	if (i == 2)
	{
		upperleft.x = upperleft.y = 0;
		ScrollToPosition(upperleft);
	}
	
	// restore old font
	pDC->SelectObject(pOldFont);
}

/////////////////////////////////////////////////////////////////////////////
// OnInitialUpdate(): Called to set initial properties of view
//                    Here we initialize scrolling
/////////////////////////////////////////////////////////////////////////////
void CTricarbView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	SetScrollSizes(MM_TEXT, ((CTricarbDoc*)GetDocument())->GetDocSize());
}

/////////////////////////////////////////////////////////////////////////////
// OnUpdate(): Called when document asks to update all views
//             This fn does not draw, but marks region(s) to be redrawn by OnDraw()
// Arguments: pSender: ptr to view that caused the message
//            lHint: 32bit value containing a hint
//            pHint: ptr to object containing hint
/////////////////////////////////////////////////////////////////////////////
void CTricarbView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint)
{
	SetScrollSizes(MM_TEXT, ((CTricarbDoc*)GetDocument())->GetDocSize());
	
	// TODO: interpret hint
	Invalidate(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
// CTricarbView diagnostics

#ifdef _DEBUG
void CTricarbView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CTricarbView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}

CTricarbDoc* CTricarbView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CTricarbDoc)));
	return (CTricarbDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CTricarbView message handlers

/////////////////////////////////////////////////////////////////////////////
// OnCommNotify(): Handler for ON_COMMNOTIFY message sent by com driver
// Arguments: wParam = idDevice
//            LOWORD(lParam) = nNotifyStatus
// Return: 0
/////////////////////////////////////////////////////////////////////////////
LRESULT CTricarbView::OnCommNotify(WPARAM wParam, LPARAM lParam)
{                                 

	int nLength, nError;
	COMSTAT ComStat;
	MSG msg;
	CString buffer;
	CString* pString;
	char szError[10];
	
	// check whether it is an event
	if (CN_EVENT & LOWORD(lParam) != CN_EVENT)
    	return 0;                                       // skip if not
    
    // clear event word so we're notified after the next event
    GetCommEventMask((int)wParam, EV_RXFLAG);
    
    do
    {
    	if (nLength = ReadCommBlock((int)wParam, /*pString*/&buffer, MAXBLOCK ))
        {
    		pString = GetDocument()->NewLine();
    		*pString = buffer;
         	GetDocument()->SaveLine(pString);

        }
        if (nError = GetCommError((int)wParam, &ComStat ))
        {
            //if (DISPLAYERRORS( npTTYInfo ))
            //{
            	wsprintf(szError, "<CE-%d>", nError);
            	*pString += szError;
            	OnUpdate(NULL, (LPARAM)0, (CObject*)NULL);
            	GetDocument()->ReportError(5, szError);
            //}
        }
    }
    while ((!PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE )) ||
            (nLength > 0));

	return 0;	
}

/////////////////////////////////////////////////////////////////////////
// ReadCommBlock(): Reads data from COM queue
// Arguments: lpszBlock: ptr to string that receives the data
//            nMaxlen: maximum string length allowed
// Returns: number of bytes read
//          FALSE if failed
///////////////////////////////////////////////////////////////////////////
int CTricarbView::ReadCommBlock(int idDevice, CString* lpszInbox, int nMaxlen)
{
	int nLength, nError, nstringLength;
	char szError[10];
	char szInbox[MAXBLOCK+1];
	
   	nLength = ReadComm(idDevice, szInbox, nMaxlen);
   	nstringLength = abs(nLength);     // nLength is negative if there was an error
   	szInbox[nstringLength] = '\0';	  // convert to a zero-terminated string
    *lpszInbox = szInbox;             // copy string to CString object
    
   	if (nLength < 0)                  // if an error occurred
   	{
      	nLength *= -1 ;
      	while (nError = GetCommError(idDevice, NULL ))
      	{
      	   	//if (DISPLAYERRORS( npTTYInfo ))
         	//{
            	wsprintf(szError, "<CE-%d>", nError);
            	*lpszInbox += szError;                  // concatenate error string
            	OnUpdate(NULL, (LPARAM)0, (CObject*)NULL);
            	GetDocument()->ReportError(5, szError);
          	//}                                      
      	}
   	}
	
	return nLength;
}

//// Debug helper: add new string
void CTricarbView::OnOptionsNewstring()
{
#if defined (_DEBUG)
    char szBuffer[128];
    CString* pString;
    
    pString = GetDocument()->NewLine();
    wsprintf(szBuffer, "3,1,205,5,100000.4599,5.5324,50000.9999,2.5,25,1\t\r\n"/*"EOP\t\r\n"*/);
    *pString = szBuffer;
    GetDocument()->SaveLine(pString);
#endif
}
