// tricarb.h : main header file for the TRICARB application
//

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       // main symbols

#define NUMFILTERS 4        // number of output filters

/////////////////////////////////////////////////////////////////////////////
// CTricarbApp:
// See tricarb.cpp for the implementation of this class
//

class CTricarbApp : public CWinApp
{
public:
	CTricarbApp();

// Overrides
	virtual BOOL InitInstance();
    virtual BOOL OnIdle(LONG lCount);
    
// Implementation
private:
	CString m_szOutPath;   // holds directory for file output
	int m_nRadioBaudRate;  // Radio button setting for Baud rate
	int m_nRadioParity;    // Radio button setting for Parity check
	int m_nRadioStopBits;  // Radio button setting for Stop bits
	int m_nRadioDataBits;  // Radio button setting for Data bits
	int m_nRadioPort;      // Radio button setting for COM Port
	
	int m_nOutFormat[15];     // array of output format filter numbers
	char m_szHeader[NUMFILTERS][81];   // array of header strings
	int m_nTerm[NUMFILTERS];		      // array for line termination options
	
	BOOL m_bIsCollecting;  // TRUE if waiting for data, FALSE if idle
    int m_nIDComDev;       // Denotes open COM device
    char m_szDCB[20];	   // Device control block string for COM setting
    char m_szPortName[5];  // Port name, e.g. "COM1"
    BOOL m_bIsFirst;	   // TRUE indicates first document (don't set status bar panes)
    BOOL m_bEOP;	       // TRUE indicates end of program, signals start of new file
    BOOL m_bSysop;         // TRUE indicates we have sysop access
    BOOL m_bRecover;	   // TRUE if powerfail recovery
	BOOL m_bLogOuterrors;  // check box setting for log output errors
	BOOL m_bLogComErrors;  // check box setting for log transmission errors
	BOOL m_bLogOnline;     // check box setting for log online/offline
	BOOL m_bLogPowerfail;  // check box setting for log powerfails
	BOOL m_bLogProtocol;   // check box setting for log start/end protocol
	BOOL m_bLogConvertErrors; // check box setting for log convert errors
	BOOL m_bLimit;         // check box setting for limit log list
	int m_nLimit;          // maximum number of items in log list
    
// Functions
public:
	BOOL CloseComPort();
	void WriteTricarbSettings();
	void WriteLog(int event, LPSTR text);	
private:
	BOOL InitializeComPort();
	void ReadTricarbSettings();
	char* MakeComString();
	virtual int ExitInstance();
	void WriteRecoverSettings();
	void ConvertIniString(char* szdestination, CString* psource, BOOL bread);

// Helpers
public:
	BYTE GetDataBits();
	UINT GetBaudRate();
	char GetParity();
	int GetStopBits();
	BOOL GetIsCollecting();
	void GetOutPath(LPSTR szPath);
	BOOL GetIsFirst();
	void FirstOff();
	int GetOutFormat(int nProgramNo);
	void SetEOPFlag();
	char* GetHeaderString(int nOutFormat);
	int GetTerminator(int nOutFormat);
	BOOL GetIsRecover();

protected:
	//{{AFX_MSG(CTricarbApp)
	afx_msg void OnAppAbout();
	afx_msg void OnOptionsOutputdirectory();
	afx_msg void OnOptionsComsettings();
	afx_msg void OnStartCollect();
	afx_msg void OnUpdateStartCollect(CCmdUI* pCmdUI);
	afx_msg void OnStopCollect();
	afx_msg void OnUpdateStopCollect(CCmdUI* pCmdUI);
	afx_msg void OnUpdateOptionsComsettings(CCmdUI* pCmdUI);
	afx_msg void OnUpdateOptionsOutputdirectory(CCmdUI* pCmdUI);
	afx_msg void OnOptionsOutputformats();
	afx_msg void OnUpdateOptionsOutputformats(CCmdUI* pCmdUI);
	afx_msg void OnOptionsHeaders();
	afx_msg void OnUpdateOptionsHeaders(CCmdUI* pCmdUI);
	afx_msg void OnFileLog();
	afx_msg void OnSystemLog();
	afx_msg void OnUpdateSystemLog(CCmdUI* pCmdUI);
	afx_msg void OnHelpFiles();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////
