// tricarb.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "tricarb.h"

#include "mainfrm.h"
#include "tricadoc.h"
#include "tricavw.h"
#include "outdir.h"
#include "comsets.h"
#include "comfns.h"
#include "outforma.h"
#include "headerst.h"
#include "logdlg.h"
#include "logoptsd.h"

#include <string.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

///////////////////////////////////////////////
// .ini statics
static char iniSection1[] = "Data";
static char iniDirectory[] = "Dir";
static char iniSection2[] = "COMSettings";
static char iniBaud[] = "Baud";
static char iniParity[] = "Parity";
static char iniStop[] = "Stopbits";
static char iniData[] = "Databits";
static char iniPort[] = "Port";
static char iniSection3[] = "OutputSettings";
static char iniOut1[] = "Out1";
static char iniOut2[] = "Out2";
static char iniOut3[] = "Out3";
static char iniOut4[] = "Out4";
static char iniOut5[] = "Out5";
static char iniOut6[] = "Out6";
static char iniOut7[] = "Out7";
static char iniOut8[] = "Out8";
static char iniOut9[] = "Out9";
static char iniOut10[] = "Out10";
static char iniOut11[] = "Out11";
static char iniOut12[] = "Out12";
static char iniOut13[] = "Out13";
static char iniOut14[] = "Out14";
static char iniOut15[] = "Out15";
static char iniSection4[] = "Headers";
static char iniHead0[] = "Head0";
static char iniHead1[] = "Head1";
static char iniHead2[] = "Head2";
static char iniHead3[] = "Head3";
static char iniTerm0[] = "Term0";
static char iniTerm1[] = "Term1";
static char iniTerm2[] = "Term2";
static char iniTerm3[] = "Term3";
static char iniSection5[] = "PowRec";
static char iniRecover[] = "Recover";
static char iniLastFile[] = "LastFile";
static char iniSection6[] = "LogOptions";
static char iniOutErrors[] = "OutErrors";
static char iniComErrors[] = "ComErrors";
static char iniOnline[] = "Online";
static char iniPowerfail[] = "Powerfail";
static char iniProtocol[] = "Protocol";
static char iniConvert[] = "Convert";
static char iniLimit[] = "LimitLog";
static char iniLimitnum[] = "LimitNumber";


/////////////////////////////////////////////////////////////////////////////
// CTricarbApp

BEGIN_MESSAGE_MAP(CTricarbApp, CWinApp)
	//{{AFX_MSG_MAP(CTricarbApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_OPTIONS_OUTPUTDIRECTORY, OnOptionsOutputdirectory)
	ON_COMMAND(ID_OPTIONS_COMSETTINGS, OnOptionsComsettings)
	ON_COMMAND(ID_START_COLLECT, OnStartCollect)
	ON_UPDATE_COMMAND_UI(ID_START_COLLECT, OnUpdateStartCollect)
	ON_COMMAND(ID_STOP_COLLECT, OnStopCollect)
	ON_UPDATE_COMMAND_UI(ID_STOP_COLLECT, OnUpdateStopCollect)
	ON_UPDATE_COMMAND_UI(ID_OPTIONS_COMSETTINGS, OnUpdateOptionsComsettings)
	ON_UPDATE_COMMAND_UI(ID_OPTIONS_OUTPUTDIRECTORY, OnUpdateOptionsOutputdirectory)
	ON_COMMAND(ID_OPTIONS_OUTPUTFORMATS, OnOptionsOutputformats)
	ON_UPDATE_COMMAND_UI(ID_OPTIONS_OUTPUTFORMATS, OnUpdateOptionsOutputformats)
	ON_COMMAND(ID_OPTIONS_HEADERS, OnOptionsHeaders)
	ON_UPDATE_COMMAND_UI(ID_OPTIONS_HEADERS, OnUpdateOptionsHeaders)
	ON_COMMAND(ID_FILE_LOG, OnFileLog)
	ON_COMMAND(ID_SYSTEM_LOG, OnSystemLog)
	ON_UPDATE_COMMAND_UI(ID_SYSTEM_LOG, OnUpdateSystemLog)
	ON_COMMAND(ID_HELP_FILES, OnHelpFiles)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTricarbApp construction

CTricarbApp::CTricarbApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CTricarbApp object

CTricarbApp NEAR theApp;

/////////////////////////////////////////////////////////////////////////////
// CTricarbApp initialization

BOOL CTricarbApp::InitInstance()
{
	HFILE handle;
	OFSTRUCT openbuff;
	CString szfilename;
	UINT ndbsize = 0;
	
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	SetDialogBkColor();        // Set dialog background color to gray
	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CTricarbDoc),
		RUNTIME_CLASS(CMainFrame),     // main SDI frame window
		RUNTIME_CLASS(CTricarbView));
	AddDocTemplate(pDocTemplate);


    // init data
    m_bIsCollecting = FALSE;
    m_bEOP = FALSE;
    m_bIsFirst = TRUE;
    m_bSysop = FALSE;
    ReadTricarbSettings();
    
	// simple command line parsing
	if (!strcmp(strupr(m_lpCmdLine), "/SYSOP"))   // switch to sysop mode
	{
		m_bSysop = TRUE;
	}
	
	// create log file, if not existent
	szfilename = m_szOutPath + "TRICARB.LOG";
	if ((handle = OpenFile(szfilename, &openbuff, OF_EXIST|OF_SHARE_COMPAT)) == HFILE_ERROR)
	{
		handle = OpenFile(szfilename, &openbuff, OF_CREATE|OF_SHARE_DENY_WRITE);
		_lwrite(handle, &ndbsize, sizeof(UINT));
		_lclose(handle);
	}
	
	// create a new (empty) document
	OnFileNew();

    
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CAboutDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	::CenterWindow(GetParent(), this);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// App command to run the dialog
void CTricarbApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CTricarbApp commands

/////////////////////////////////////////////////////////////////////////////
// Handlers

/////////////////////////////////////////////////////////////////////////////
// OnOptionsOutputdirectory(): Handler for menu command Output directory
/////////////////////////////////////////////////////////////////////////////
void CTricarbApp::OnOptionsOutputdirectory()
{
	COutDir dlg;
	
	dlg.m_szOutPath = m_szOutPath;
	
	if (dlg.DoModal() == IDOK)
	{
		m_szOutPath = dlg.m_szOutPath;
		
		// add a backslash, if necessary
		if (m_szOutPath[m_szOutPath.GetLength()-1] != '\\')
		{
			m_szOutPath += "\\";
		}
		WriteTricarbSettings();
	}
	
}

void CTricarbApp::OnUpdateOptionsOutputdirectory(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(!m_bIsCollecting && m_bSysop);	// switch off if waiting for data or no access	
}

////////////////////////////////////////////////////////////////////////////////
// OnOptionsComsettings(): Handler for menu command COM settings
////////////////////////////////////////////////////////////////////////////////
void CTricarbApp::OnOptionsComsettings()
{
	CComSets dlg;
	
	dlg.m_nRadioBaudRate = m_nRadioBaudRate;
	dlg.m_nRadioParity = m_nRadioParity;
	dlg.m_nRadioStopBits = m_nRadioStopBits;
	dlg.m_nRadioDataBits = m_nRadioDataBits;
	dlg.m_nRadioPort = m_nRadioPort;
	
	if (dlg.DoModal() == IDOK)
	{
		m_nRadioBaudRate = dlg.m_nRadioBaudRate;
		m_nRadioParity = dlg.m_nRadioParity;
		m_nRadioStopBits = dlg.m_nRadioStopBits;
		m_nRadioDataBits = dlg.m_nRadioDataBits;
		m_nRadioPort = dlg.m_nRadioPort;
		MakeComString();
		WriteTricarbSettings();
	}
	
}
void CTricarbApp::OnUpdateOptionsComsettings(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(!m_bIsCollecting && m_bSysop);	// switch off if waiting for data or no access	
}

/////////////////////////////////////////////////////////////////////
// OnSystemLog(): Handler for Log options menu command
/////////////////////////////////////////////////////////////////////
void CTricarbApp::OnSystemLog()
{
	CLogOptsDlg dlg;
	
	dlg.m_bLogOuterrors = m_bLogOuterrors; 
	dlg.m_bLogComErrors = m_bLogComErrors;  
	dlg.m_bLogOnline = m_bLogOnline;     
	dlg.m_bLogPowerfail = m_bLogPowerfail;  
	dlg.m_bLogProtocol = m_bLogProtocol;
	dlg.m_bLogConvertErrors = m_bLogConvertErrors;
	dlg.m_bLimit = m_bLimit;
	dlg.m_nLimit = m_nLimit;
	  
	if (dlg.DoModal() == IDOK)
	{
		m_bLogOuterrors = dlg.m_bLogOuterrors; 
		m_bLogComErrors = dlg.m_bLogComErrors;  
		m_bLogOnline = dlg.m_bLogOnline;     
		m_bLogPowerfail = dlg.m_bLogPowerfail;  
		m_bLogProtocol = dlg.m_bLogProtocol;
		m_bLogConvertErrors = dlg.m_bLogConvertErrors;
		m_bLimit = dlg.m_bLimit;
		m_nLimit = dlg.m_nLimit;
		WriteTricarbSettings();  
	}
	
}

void CTricarbApp::OnUpdateSystemLog(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(/*!m_bIsCollecting &&*/ m_bSysop);	// switch off if waiting for data or no access	
}
////////////////////////////////////////////////////////////////////////////////////
// OnOptionsOutputformats(): Handler for menu command Output formats
////////////////////////////////////////////////////////////////////////////////////
void CTricarbApp::OnOptionsOutputformats()
{
	COutFormats dlg;
	
	dlg.m_nOutFormat1 = m_nOutFormat[0];
	dlg.m_nOutFormat2 = m_nOutFormat[1];
	dlg.m_nOutFormat3 = m_nOutFormat[2];
	dlg.m_nOutFormat4 = m_nOutFormat[3];
	dlg.m_nOutFormat5 = m_nOutFormat[4];
	dlg.m_nOutFormat6 = m_nOutFormat[5];
	dlg.m_nOutFormat7 = m_nOutFormat[6];
	dlg.m_nOutFormat8 = m_nOutFormat[7];
	dlg.m_nOutFormat9 = m_nOutFormat[8];
	dlg.m_nOutFormat10 = m_nOutFormat[9];
	dlg.m_nOutFormat11 = m_nOutFormat[10];
	dlg.m_nOutFormat12 = m_nOutFormat[11];
	dlg.m_nOutFormat13 = m_nOutFormat[12];
	dlg.m_nOutFormat14 = m_nOutFormat[13];
	dlg.m_nOutFormat15 = m_nOutFormat[14];
	
	if (dlg.DoModal() == IDOK)
	{
		m_nOutFormat[0] = dlg.m_nOutFormat1;
		m_nOutFormat[1] = dlg.m_nOutFormat2;
		m_nOutFormat[2] = dlg.m_nOutFormat3;
		m_nOutFormat[3] = dlg.m_nOutFormat4;
		m_nOutFormat[4] = dlg.m_nOutFormat5;
		m_nOutFormat[5] = dlg.m_nOutFormat6;
		m_nOutFormat[6] = dlg.m_nOutFormat7;
		m_nOutFormat[7] = dlg.m_nOutFormat8;
		m_nOutFormat[8] = dlg.m_nOutFormat9;
		m_nOutFormat[9] = dlg.m_nOutFormat10;
		m_nOutFormat[10] = dlg.m_nOutFormat11;
		m_nOutFormat[11] = dlg.m_nOutFormat12;
		m_nOutFormat[12] = dlg.m_nOutFormat13;
		m_nOutFormat[13] = dlg.m_nOutFormat14;
		m_nOutFormat[14] = dlg.m_nOutFormat15;
		WriteTricarbSettings();
	}
}

////////////////////////////////////////////////////////////////////////////////////
// OnUpdateOptionsOutputformats(): Update handler for menu command Output formats
////////////////////////////////////////////////////////////////////////////////////
void CTricarbApp::OnUpdateOptionsOutputformats(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(!m_bIsCollecting);	// switch off if waiting for data	
}

////////////////////////////////////////////////////////////////////////////////////
// OnOptionsHeaders(): Handler for menu command Headers
////////////////////////////////////////////////////////////////////////////////////
void CTricarbApp::OnOptionsHeaders()
{
	CHeaderStringDlg dlg;
	int i;
	
	for (i = 0; i < NUMFILTERS; i++)
	{
		strcpy(&dlg.m_szHeader[i][0], &m_szHeader[i][0]);
		dlg.m_nTerm[i] = m_nTerm[i];
	}
	
	if (dlg.DoModal() == IDOK)
	{
		for (i = 0; i < NUMFILTERS; i++)
		{
			strcpy(&m_szHeader[i][0], &dlg.m_szHeader[i][0]);
			m_nTerm[i] = dlg.m_nTerm[i];
		}
		WriteTricarbSettings();
	}
}

////////////////////////////////////////////////////////////////////////////////////
// OnUpdateOptionsHeaders(): Update handler for menu command Headers
////////////////////////////////////////////////////////////////////////////////////
void CTricarbApp::OnUpdateOptionsHeaders(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(!m_bIsCollecting);	// switch off if waiting for data	
}
////////////////////////////////////////////////////////////////////////////////////
// OnStartCollect(): Handler for menu command Start collecting data
////////////////////////////////////////////////////////////////////////////////////
void CTricarbApp::OnStartCollect()
{
	if (m_bIsCollecting)           // Jump out if we're already online
	{
		return;
	}
	if (InitializeComPort() == TRUE)
	{
		WriteLog(0, NULL);
		m_bIsCollecting = TRUE;	    // toggle on status variable
		OnFileNew();		
		((CMainFrame*)m_pMainWnd)->SetWindowText("Tricarb Monitor - Online");
	}
}

////////////////////////////////////////////////////////////////////////////////////
// OnUpdateStartCollect(): Update-Handler for menu command Start collecting data
////////////////////////////////////////////////////////////////////////////////////
void CTricarbApp::OnUpdateStartCollect(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck(m_bIsCollecting);	// switch off if waiting for data	
}

////////////////////////////////////////////////////////////////////////////////////
// OnStopCollect(): Handler for menu command Stop collecting data
////////////////////////////////////////////////////////////////////////////////////
void CTricarbApp::OnStopCollect()
{
	if (!m_bIsCollecting)          // jump out if we're already offline
	{
		return;
	}
	CloseComPort();
	m_bIsCollecting = FALSE;
	((CMainFrame*)m_pMainWnd)->SetWindowText("Tricarb Monitor - Offline");		
}

////////////////////////////////////////////////////////////////////////////////////
// OnUpdateStopCollect(): Update handler for menu command Stop collecting data
////////////////////////////////////////////////////////////////////////////////////
void CTricarbApp::OnUpdateStopCollect(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck(!m_bIsCollecting);	// switch on if waiting for data	
}

////////////////////////////////////////////////////////////////////////////////////
// OnFileLog(): Handler for Log file menu command
////////////////////////////////////////////////////////////////////////////////////
void CTricarbApp::OnFileLog()
{
	CLogDlg dlg;
	
	dlg.m_szFileName = m_szOutPath + "TRICARB.LOG";
	dlg.m_bLimit = m_bLimit;
	dlg.m_nLimit = m_nLimit;
	
	dlg.DoModal();	// we don't check for OK as all necessary things happen in CLogDlg
	
}

////////////////////////////////////////////////////////////////////////////////////
// OnHelpFiles(): Handler for the Where are my files? menu command
////////////////////////////////////////////////////////////////////////////////////
void CTricarbApp::OnHelpFiles()
{
	char messagetext[512];
	wsprintf(messagetext, "The data directory is: %s\nWithin this directory, the output files are stored in subdirectories according to the counter protocol. If in doubt, consult the Log file to see the most recently created files.", m_szOutPath);
	AfxMessageBox(messagetext, MB_ICONINFORMATION|MB_OK);	
}

////////////////////////////////////////////////////////////////////////////////////
// OnIdle(): Performs background tasks when app is idle.
//           We use it to switch to a new document when EOP was detected
//           and to start counting automatically after a powerfail
// Argument: lCount: Counter of calls after last message
// Return: FALSE if no more background time necessary, TRUE if more time desired
////////////////////////////////////////////////////////////////////////////////////
BOOL CTricarbApp::OnIdle(LONG lCount)
{
	BOOL bresponse;
	
	// first call base class handler
	bresponse = CWinApp::OnIdle(lCount);
	
	if (m_bEOP)
	{
		OnFileNew();       // start a new document
		m_bEOP = FALSE;    // reset EOP flag
		((CMainFrame*)m_pMainWnd)->SetWindowText("Tricarb Monitor - Online");
		WriteRecoverSettings();		
	}
	
	if (m_bRecover)
	{
		WriteLog(2, NULL);
		OnStartCollect();   // start collecting data
		m_bRecover = FALSE;	// reset powerfail recovery flag
	}
	
	return bresponse;   // return base class response
}

////////////////////////////////////////////////////////////////////////////////////
// InitializeComPort(): Initializes com port according to dialog settings
////////////////////////////////////////////////////////////////////////////////////
BOOL CTricarbApp::InitializeComPort()
{
	int err;
	DCB dcb;
	
	// TODO: if open com fails, call close com
	// Try to open COM port. Loop to allow user to close other COM apps
	do 
	{
		m_nIDComDev = OpenComm((const char _far*)&m_szPortName, MAXBLOCK, 128);
		if (m_nIDComDev < 0)
		{
			if (AfxMessageBox("COM port could not be initialized. Close or disconnect other apps addressing this COM port and try again", MB_RETRYCANCEL) == IDCANCEL)
				return FALSE;
		}
	}while (m_nIDComDev < 0);
	
	// build a device control block
	err = BuildCommDCB(m_szDCB,&dcb);
	//err = GetCommState(m_nIDComDev, &dcb);
	if (err < 0)
	{
		AfxMessageBox("COM port could not be initialized. Check the COM settings.");
		return FALSE;
	}
	
	// modify device control block to our needs
	dcb.RlsTimeout = 0;
	dcb.CtsTimeout = 0;
	dcb.DsrTimeout = 0;
	dcb.fDtrDisable = 0;
	dcb.fRtsDisable = 0;	// set to high for counter LPT signalling purposes
	dcb.EvtChar = 10;    // event character is /n (linefeed)
	dcb.fChEvt = 1;
	dcb.fBinary = 1;
	dcb.fParity = 1;
	// hardware flow control
	dcb.fOutxCtsFlow = 1;
	dcb.fRtsflow = 1;
	// actually set the parameters defined in device control block
	err = SetCommState(&dcb);
	if (err < 0)
	{
		AfxMessageBox("COM port could not be initialized. Check the COM settings.");
		return FALSE;
	}
	
	// enable event notification for document window
    SetCommEventMask(m_nIDComDev, EV_RXFLAG) ;   // we will be notified whenever a cr is sent (dcb.EvtChar)
    // we will receive only CN_EVENT messages
	EnableCommNotification(m_nIDComDev, (((CFrameWnd*)m_pMainWnd)->GetActiveView())->m_hWnd, -1, -1);
	return TRUE;
}

////////////////////////////////////////////////////////////////////////////////////
// CloseComPort(): Closes com port
// Return: TRUE if successful, FALSE if error occurred
////////////////////////////////////////////////////////////////////////////////////
BOOL CTricarbApp::CloseComPort()
{
	// disable event notification
	EnableCommNotification(m_nIDComDev, NULL, -1,-1);

	WriteRecoverSettings();
	WriteLog(1, NULL);
	
	if (CloseComm(m_nIDComDev) < 0)
	{
		AfxMessageBox("COM port could not be closed properly");
		return FALSE;
	}
	
	return TRUE;
}

////////////////////////////////////////////////////////////////////////////////////
// ExitInstance(): Called when application quits
//                 Here we close the com port if necessary
// Return: 0 if no error, > 0 if error occurred
////////////////////////////////////////////////////////////////////////////////////
int CTricarbApp::ExitInstance()
{
	int retValue;
	
	retValue = CWinApp::ExitInstance();
	if (m_bIsCollecting)
	{
		if (!CloseComPort())
		{
			retValue += 1;
		}
	}
	return retValue;
}
////////////////////////////////////////////////////////////////////////////////////
// Helpers for accessing ini file

////////////////////////////////////////////////////////////////////////////////////
// ReadTricarbSettings(): Reads settings from ini file
////////////////////////////////////////////////////////////////////////////////////
void CTricarbApp::ReadTricarbSettings()
{
	CString string;
	
	m_szOutPath = GetProfileString(iniSection1, iniDirectory, "C:\\");
	m_nRadioBaudRate = GetProfileInt(iniSection2, iniBaud, 2);
	m_nRadioParity = GetProfileInt(iniSection2, iniParity, 1);
	m_nRadioStopBits = GetProfileInt(iniSection2, iniStop, 0);
	m_nRadioDataBits = GetProfileInt(iniSection2, iniData, 0);
	m_nRadioPort = GetProfileInt(iniSection2, iniPort, 0);
	MakeComString();
	m_nOutFormat[0] = GetProfileInt(iniSection3, iniOut1, 0);
	m_nOutFormat[1] = GetProfileInt(iniSection3, iniOut2, 0);
	m_nOutFormat[2] = GetProfileInt(iniSection3, iniOut3, 0);
	m_nOutFormat[3] = GetProfileInt(iniSection3, iniOut4, 0);
	m_nOutFormat[4] = GetProfileInt(iniSection3, iniOut5, 0);
	m_nOutFormat[5] = GetProfileInt(iniSection3, iniOut6, 0);
	m_nOutFormat[6] = GetProfileInt(iniSection3, iniOut7, 0);
	m_nOutFormat[7] = GetProfileInt(iniSection3, iniOut8, 0);
	m_nOutFormat[8] = GetProfileInt(iniSection3, iniOut9, 0);
	m_nOutFormat[9] = GetProfileInt(iniSection3, iniOut10, 0);
	m_nOutFormat[10] = GetProfileInt(iniSection3, iniOut11, 0);
	m_nOutFormat[11] = GetProfileInt(iniSection3, iniOut12, 0);
	m_nOutFormat[12] = GetProfileInt(iniSection3, iniOut13, 0);
	m_nOutFormat[13] = GetProfileInt(iniSection3, iniOut14, 0);
	m_nOutFormat[14] = GetProfileInt(iniSection3, iniOut15, 0);
	string = GetProfileString(iniSection4, iniHead0, "");
	//strcpy(&m_szHeader[0][0], string);
	ConvertIniString(&m_szHeader[0][0], &string, TRUE);
	string = GetProfileString(iniSection4, iniHead1, "");
	//strcpy(&m_szHeader[1][0], string);
	ConvertIniString(&m_szHeader[1][0], &string, TRUE);
	string = GetProfileString(iniSection4, iniHead2, "");
	//strcpy(&m_szHeader[2][0], string);
	ConvertIniString(&m_szHeader[2][0], &string, TRUE);
	string = GetProfileString(iniSection4, iniHead3, "");
	//strcpy(&m_szHeader[3][0], string);
	ConvertIniString(&m_szHeader[3][0], &string, TRUE);
	m_nTerm[0] = GetProfileInt(iniSection3, iniTerm0, 0);
	m_nTerm[1] = GetProfileInt(iniSection3, iniTerm1, 0);
	m_nTerm[2] = GetProfileInt(iniSection3, iniTerm2, 0);
	m_nTerm[3] = GetProfileInt(iniSection3, iniTerm3, 0);
	m_bRecover = GetProfileInt(iniSection5, iniRecover, 0);
	m_bLogOuterrors = (BOOL)GetProfileInt(iniSection6, iniOutErrors, 1);
	m_bLogComErrors = (BOOL)GetProfileInt(iniSection6, iniComErrors, 1);
	m_bLogOnline = (BOOL)GetProfileInt(iniSection6, iniOnline, 1);
	m_bLogPowerfail = (BOOL)GetProfileInt(iniSection6, iniPowerfail, 1);
	m_bLogProtocol = (BOOL)GetProfileInt(iniSection6, iniProtocol, 1);
	m_bLogConvertErrors = (BOOL)GetProfileInt(iniSection6, iniConvert, 1);
	m_bLimit = (BOOL)GetProfileInt(iniSection6, iniLimit, 1);
	m_nLimit = GetProfileInt(iniSection6, iniLimitnum, 100);
}

////////////////////////////////////////////////////////////////////////////////////
// WriteTricarbSettings(): Writes settings to ini file
////////////////////////////////////////////////////////////////////////////////////
void CTricarbApp::WriteTricarbSettings()
{
	CString buffer;
	
	WriteProfileString(iniSection1, iniDirectory, m_szOutPath);
	WriteProfileInt(iniSection2, iniBaud, m_nRadioBaudRate);
	WriteProfileInt(iniSection2, iniParity, m_nRadioParity);
	WriteProfileInt(iniSection2, iniStop, m_nRadioStopBits);
	WriteProfileInt(iniSection2, iniData, m_nRadioDataBits);
	WriteProfileInt(iniSection2, iniPort, m_nRadioPort);
	WriteProfileInt(iniSection3, iniOut1, m_nOutFormat[0]);
	WriteProfileInt(iniSection3, iniOut2, m_nOutFormat[1]);
	WriteProfileInt(iniSection3, iniOut3, m_nOutFormat[2]);
	WriteProfileInt(iniSection3, iniOut4, m_nOutFormat[3]);
	WriteProfileInt(iniSection3, iniOut5, m_nOutFormat[4]);
	WriteProfileInt(iniSection3, iniOut6, m_nOutFormat[5]);
	WriteProfileInt(iniSection3, iniOut7, m_nOutFormat[6]);
	WriteProfileInt(iniSection3, iniOut8, m_nOutFormat[7]);
	WriteProfileInt(iniSection3, iniOut9, m_nOutFormat[8]);
	WriteProfileInt(iniSection3, iniOut10, m_nOutFormat[9]);
	WriteProfileInt(iniSection3, iniOut11, m_nOutFormat[10]);
	WriteProfileInt(iniSection3, iniOut12, m_nOutFormat[11]);
	WriteProfileInt(iniSection3, iniOut13, m_nOutFormat[12]);
	WriteProfileInt(iniSection3, iniOut14, m_nOutFormat[13]);
	WriteProfileInt(iniSection3, iniOut15, m_nOutFormat[14]);
	ConvertIniString(&m_szHeader[0][0], &buffer, FALSE);
	WriteProfileString(iniSection4, iniHead0, buffer);
	ConvertIniString(&m_szHeader[1][0], &buffer, FALSE);
	WriteProfileString(iniSection4, iniHead1, buffer);
	ConvertIniString(&m_szHeader[2][0], &buffer, FALSE);
	WriteProfileString(iniSection4, iniHead2, buffer);
	ConvertIniString(&m_szHeader[3][0], &buffer, FALSE);
	WriteProfileString(iniSection4, iniHead3, buffer);
	WriteProfileInt(iniSection3, iniTerm0, m_nTerm[0]);
	WriteProfileInt(iniSection3, iniTerm1, m_nTerm[1]);
	WriteProfileInt(iniSection3, iniTerm2, m_nTerm[2]);
	WriteProfileInt(iniSection3, iniTerm3, m_nTerm[3]);
	WriteProfileInt(iniSection6, iniOutErrors, m_bLogOuterrors);
	WriteProfileInt(iniSection6, iniComErrors, m_bLogComErrors);
	WriteProfileInt(iniSection6, iniOnline, m_bLogOnline);
	WriteProfileInt(iniSection6, iniPowerfail, m_bLogPowerfail);
	WriteProfileInt(iniSection6, iniProtocol, m_bLogProtocol);
	WriteProfileInt(iniSection6, iniConvert, m_bLogConvertErrors);
	WriteProfileInt(iniSection6, iniLimit, m_bLimit);
	WriteProfileInt(iniSection6, iniLimitnum, m_nLimit);
}

////////////////////////////////////////////////////////////////////////////////////
// WriteRecoverSettings(): Sets back recover information in .ini file
////////////////////////////////////////////////////////////////////////////////////
void CTricarbApp::WriteRecoverSettings()
{
	WriteProfileInt(iniSection5, iniRecover, (int)FALSE);
    WriteProfileString(iniSection5, iniLastFile, "C:\\RECOVER.TXT");
}

/////////////////////////////////////////////////////////////////////////////////////
// ConvertIniString(): Sets or removes tabs from ini strings
//                     WriteProfileString()/ReadProfileString() cannot handle strings
//                     that contain tabs: all chars after the first tab get lost
//                     (This bug in Win31 has been cured in NT's WOW!)
// Arguments: szdestination: ptr to string. Will receive converted string if bread is TRUE
//                     Holds string to be converted if bread is FALSE
//            psource: ptr to CString. Holds string to be converted if bread is TRUE
//                     Will receive converted string if bread is FALSE
//            bread:   TRUE if we read from ini file, FALSE if we save to ini file
/////////////////////////////////////////////////////////////////////////////////////
void CTricarbApp::ConvertIniString(char* szdestination, CString* psource, BOOL bread)
{
	int index;
	
	if (bread)      // if we read from ini file
	{
		do
		{
			index = psource->Find('@');
			if (index != -1)                 // if the string contains a hidden tab,...
			{
				psource->SetAt(index, '\t'); // replace it with a tab
			}
		}
		while (index != -1);
		strcpy(szdestination, *psource);
	}
	else
	{
		*psource = szdestination;
		do
		{
			index = psource->Find('\t');
			if (index != -1)                 // if the string contains a tab,...
			{
				psource->SetAt(index, '@'); // replace it with a hidden tab
			}
		}
		while (index != -1);
	}
}

////////////////////////////////////////////////////////////////////////////////////
// WriteLog(): Writes event to the log file
// Arguments: event: number of event to log
//            text: ptr to char:variable part of event message, if necessary, NULL if not
// Event list:
//             0  gone online
//             1  gone offline
//             2  powerfail
//             3  started protocol
//             4  ended protocol
//             5  Transmission error
//             6  Output error
//             7  Conversion error
//////////////////////////////////////////////////////////////////////////////////// 
void CTricarbApp::WriteLog(int event, LPSTR text)
{
	CString szfilename, szlocalTime, szalternatefile;
	HFILE handle;
	OFSTRUCT openbuff;
	char outtext[80];
	CTime tlocalTime;
	int ndbsize = 0;
	BOOL neventlist[7];
	
	// initialize event list
	neventlist[0] = m_bLogOnline;
	neventlist[1] = m_bLogOnline;
	neventlist[2] = m_bLogPowerfail;
	neventlist[3] = m_bLogProtocol;
	neventlist[4] = m_bLogProtocol;
	neventlist[5] = m_bLogComErrors;
	neventlist[6] = m_bLogOuterrors;

	// test whether event should be logged
	if (!neventlist[event])
	{
		return;
	}
	
	// open log file for write
	szfilename = m_szOutPath + "TRICARB.LOG";
	if ((handle = OpenFile(szfilename, &openbuff, OF_READWRITE|OF_SHARE_DENY_WRITE)) == HFILE_ERROR)
	{
		return;
	}
	
	if (_llseek(handle, 0L, 0) == HFILE_ERROR)
	{
		_lclose(handle); 
	    return;
	}
	_lread(handle, (void _huge*)&ndbsize, sizeof(int));
	
	// to prevent ndbsize from wrapping, we rename the full log file and start a new one 
	if (ndbsize == 32767)
	{
		ndbsize = 0;
		_lclose(handle);
		szalternatefile = m_szOutPath + "TRICARB.LOO";
		OpenFile(szalternatefile, &openbuff, OF_DELETE);  // delete a possibly existing backup log
		rename(szfilename, szalternatefile);		      // rename log to backup log
		if ((handle = OpenFile(szfilename, &openbuff, OF_CREATE)) == HFILE_ERROR) // create empty log
		{
			return;
		}
	}
	
	// move to end of file
	if (_llseek(handle, 0L, 2) == HFILE_ERROR)
	{
		_lclose(handle);
		return;
	}
	
	// get date and time
	tlocalTime = CTime::GetCurrentTime();
	szlocalTime = tlocalTime.Format("%c  ");
	strncpy(outtext, (const char*)szlocalTime, 80);
	
	switch (event)
	{
		case 0:
			if (m_bLogOnline)
			{
				strcat(outtext, "Online");
			}
			break;
		case 1:
			strcat(outtext, "Offline");
			break;
		case 2:
			strcat(outtext, "Powerfail recovery");
			break;
		case 3:
			strcat(outtext, "Started writing ");
			strcat(outtext, text);
			break;
		case 4:
			strcat(outtext, "Finished writing ");
			strcat(outtext, text);
			break;
		case 5:
			strcat(outtext, "Transmission error in ");
			strcat(outtext, text);
			break;
		case 6:
			strcat(outtext, "Output error in ");
			strcat(outtext, text);
			break;
		case 7:
			strcat(outtext, "Convert error in ");
			strcat(outtext, text);
			break;
		default:
			break;
	}
	if (_lwrite(handle, outtext, 80) == HFILE_ERROR)
	{
		_lclose(handle);
		return;
	}
	if (ndbsize < 65535)
	{
		ndbsize++;
	}
	_llseek(handle, 0L, 0);
	_lwrite(handle, (void _huge*)&ndbsize, sizeof(UINT)); 
	_lclose(handle);
}

////////////////////////////////////////////////////////////////////////////////////
// some helpers
BYTE CTricarbApp::GetDataBits()
{
	BYTE DataBits;
	
	DataBits = (m_nRadioDataBits == 0) ? 7:8;
	
	return DataBits;
}

UINT CTricarbApp::GetBaudRate()
{
	UINT BaudRate;
	
	switch (m_nRadioBaudRate)
	{
		case 0:
			BaudRate = 1200;
			break;
		case 1:
			BaudRate = 2400;
			break;
		case 2:
			BaudRate = 9600;
			break;
	}
	return BaudRate;
}

char CTricarbApp::GetParity()
{
	char Parity;
	
	switch (m_nRadioParity)
	{
		case 0:
			Parity = 'n';
			break;
		case 1:
			Parity = 'e';
			break;
		case 2:
			Parity = 'o';
			break;
	}
    return Parity;
}

int CTricarbApp::GetStopBits()
{
	int StopBits;
	
	switch (m_nRadioStopBits)
	{
		case 0:
			StopBits = 1;
			break;
		case 1:
			StopBits = 1;
			break;
		case 2:
			StopBits = 2;
			break;
	}
    return StopBits;
}

BOOL CTricarbApp::GetIsCollecting()
{
	return m_bIsCollecting;
}

char* CTricarbApp::MakeComString()
{
	sprintf(m_szPortName, "COM%i", m_nRadioPort+1);
	sprintf(m_szDCB, "COM%i:%i,%c,%i,%i",m_nRadioPort+1, GetBaudRate(), GetParity(), GetDataBits(), GetStopBits()); 
    return m_szDCB;
}

void CTricarbApp::GetOutPath(LPSTR szPath)
{
	strcpy(szPath, m_szOutPath);
}

BOOL CTricarbApp::GetIsFirst()
{
	return m_bIsFirst;
}

void CTricarbApp::FirstOff()
{
	m_bIsFirst = FALSE;
}

int CTricarbApp::GetOutFormat(int nProgramNo)
{
	return m_nOutFormat[nProgramNo-1];
}

void CTricarbApp::SetEOPFlag()
{
	m_bEOP = TRUE;
}

char* CTricarbApp::GetHeaderString(int nOutFormat)
{
	return &m_szHeader[nOutFormat][0];
}

int CTricarbApp::GetTerminator(int nOutFormat)
{
	return m_nTerm[nOutFormat];
}

BOOL CTricarbApp::GetIsRecover()
{
	return m_bRecover;
}


