// mainfrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "tricarb.h"

#include "mainfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_QUERYENDSESSION()
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
	// Global help commands
	ON_COMMAND(ID_HELP_INDEX, CFrameWnd::OnHelpIndex)
	ON_COMMAND(ID_HELP_USING, CFrameWnd::OnHelpUsing)
	ON_COMMAND(ID_HELP, CFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CFrameWnd::OnHelpIndex)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// arrays of IDs used to initialize control bars

// toolbar buttons - IDs are command buttons
static UINT BASED_CODE buttons[] =
{
	// same order as in the bitmap 'toolbar.bmp'
	ID_START_COLLECT,
	ID_STOP_COLLECT,
	ID_FILE_LOG,
		ID_SEPARATOR,
	ID_APP_ABOUT,
	ID_CONTEXT_HELP,
};

static UINT BASED_CODE indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_SEPARATOR,           // filename of output file
	ID_SEPARATOR,           // counter program no.
	ID_SEPARATOR,           // sample no.
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	UINT nID, nStyle;
	int cxWidth;
	
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadBitmap(IDR_MAINFRAME) ||
		!m_wndToolBar.SetButtons(buttons,
		  sizeof(buttons)/sizeof(UINT)))
	{
		TRACE("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE("Failed to create status bar\n");
		return -1;      // fail to create
	}

	m_wndStatusBar.GetPaneInfo(1, nID, nStyle, cxWidth);
	m_wndStatusBar.SetPaneInfo(1, nID, nStyle, 90);      // Set new width
	m_wndStatusBar.GetPaneInfo(2, nID, nStyle, cxWidth);
	m_wndStatusBar.SetPaneInfo(2, nID, nStyle, 30);      // Set new width
	m_wndStatusBar.GetPaneInfo(3, nID, nStyle, cxWidth);
	m_wndStatusBar.SetPaneInfo(3, nID, nStyle, 40);      // Set new width
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

/////////////////////////////////////////////////////////////////////////////
// OnQueryEndSession(): Called when user wants to finish his windows session.
// If still online, user is asked to confirm going offline
// Return: TRUE if safe to quit, FALSE if not
/////////////////////////////////////////////////////////////////////////////
BOOL CMainFrame::OnQueryEndSession()
{
	if (!CFrameWnd::OnQueryEndSession())
		return FALSE;
	
	if (((CTricarbApp*)AfxGetApp())->GetIsCollecting())
	{
		if (AfxMessageBox("Tricarb is still connected. Do you really want to quit?", MB_YESNO) == IDYES)
		{
			((CTricarbApp*)AfxGetApp())->CloseComPort();
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
	else
	{
		return TRUE;
	}
}

/////////////////////////////////////////////////////////////////////////////////
// OnClose(): Called when program exits
/////////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnClose()
{
	// Write settings to ini file
	((CTricarbApp*)AfxGetApp())->WriteTricarbSettings();
	
	CFrameWnd::OnClose();
}

/////////////////////////////////////////////////////////////////////////////////
// UpdateStatusLine(): Updates status line texts in panes 1-3
// Arguments: nID: zero-based ID of pane
//            PaneText: ptr to new text of pane
/////////////////////////////////////////////////////////////////////////////////	
void CMainFrame::UpdateStatusLine(UINT nID, LPSTR PaneText)
{
	m_wndStatusBar.SetPaneText(nID, PaneText, TRUE);
	/*switch (nID)
	{
		case 1:
			m_wndStatusBar.SetPaneText(1, PaneText, TRUE);
			break;
		case 2:
			m_wndStatusBar.SetPaneText(2, PaneText, TRUE);
			break;
		case 3:
			m_wndStatusBar.SetPaneText(3, PaneText, TRUE);
			break;
	}*/
}

