// logdlg.cpp : implementation file
//

#include "stdafx.h"
#include "tricarb.h"
#include "logdlg.h"
#include "comfns.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLogDlg dialog


CLogDlg::CLogDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLogDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLogDlg)
	//}}AFX_DATA_INIT
}

void CLogDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLogDlg)
	DDX_Control(pDX, IDC_LIST1, m_LBLogList);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLogDlg, CDialog)
	//{{AFX_MSG_MAP(CLogDlg)
	ON_BN_CLICKED(IDC_DELETE, OnDelete)
	ON_BN_CLICKED(IDC_DELETEALL, OnDeleteall)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLogDlg message handlers

BOOL CLogDlg::OnInitDialog()
{
	HFILE handle;
	OFSTRUCT openbuff;
	int i, nitemsToRead, nitemsToSkip;
	char textbuf[80];
	
	CDialog::OnInitDialog();
	
	::CenterWindow(GetParent(), this);    // center dialog in frame window
	
	// open log file
	if ((handle = OpenFile(m_szFileName, &openbuff, OF_READ|OF_SHARE_DENY_WRITE)) == HFILE_ERROR)
	{
		AfxMessageBox("Can't open log file", IDOK|MB_ICONSTOP);
		return FALSE;
	}
	if (_llseek(handle, 0L, 0) == HFILE_ERROR)
	{
		_lclose(handle);
		AfxMessageBox("Can't read log file", IDOK|MB_ICONSTOP);
		return FALSE;
	}
	
	// read number of entries
	if (_lread(handle, &m_nitemsOnStart, sizeof(int)) == HFILE_ERROR)
	{
		_lclose(handle);
		AfxMessageBox("Can't read log file", IDOK|MB_ICONSTOP);
		return FALSE;
	}
	
	nitemsToRead = m_nitemsOnStart;     // save number of items for later comparison in OnOK
	if (m_bLimit && (m_nitemsOnStart > m_nLimit))     // if list must be cropped
	{
		nitemsToRead = m_nLimit;
		nitemsToSkip = m_nitemsOnStart - nitemsToRead;
		
		if (_llseek(handle, ((long)nitemsToSkip)*80, 1) == HFILE_ERROR)   // skip oldest entries
		{
			_lclose(handle);
			AfxMessageBox("Can't read log file", IDOK|MB_ICONSTOP);
			return FALSE;
		}
	}
	
	for (i = 0; i < nitemsToRead; i++)          // read wanted entries into listbox
	{
		if (_lread(handle, textbuf, 80) == HFILE_ERROR)
		{
			break;
		}
		else
		{
			m_LBLogList.InsertString(0, textbuf);
		}
	}
	_lclose(handle);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}


////////////////////////////////////////////////////////////////////////////////////
// OnOK(): called when user presses OK button
////////////////////////////////////////////////////////////////////////////////////
void CLogDlg::OnOK()
{
	CDialog::OnOK();
	
	HFILE handle;
	OFSTRUCT openbuff;
	int ndbsize, i, numitems;
	char textbuf[80];
	
	// open log file
	if ((handle = OpenFile(m_szFileName, &openbuff, OF_READ|OF_SHARE_DENY_WRITE)) == HFILE_ERROR)
	{
		AfxMessageBox("Can't open log file", IDOK|MB_ICONSTOP);
		return;
	}
	if (_llseek(handle, 0L, 0) == HFILE_ERROR)
	{
		_lclose(handle);
		AfxMessageBox("Can't read log file", IDOK|MB_ICONSTOP);
		return;
	}
	
	// read number of entries
	if (_lread(handle, &ndbsize, sizeof(int)) == HFILE_ERROR)
	{
		_lclose(handle);
		AfxMessageBox("Can't read log file", IDOK|MB_ICONSTOP);
		return;
	}
	
	if (ndbsize > m_nitemsOnStart)     // if a log event occurred while dialog box was open
	{
		if (_llseek(handle, ((long)m_nitemsOnStart)*80, 1) == HFILE_ERROR)   // search newly added items
		{
			_lclose(handle);
			AfxMessageBox("Can't read log file", IDOK|MB_ICONSTOP);
			return;
		}
		for (i = 0; i < ndbsize - m_nitemsOnStart; i++)
		{
			if (_lread(handle, textbuf, 80) == HFILE_ERROR)
			{
				break;
			}
			else
			{
				m_LBLogList.InsertString(0, textbuf);               // add new items to listbox head
			}
		}
	}
	_lclose(handle);
	
	UpdateData(TRUE);
	
	// force file to be truncated for rewriting
	if ((handle = OpenFile(m_szFileName, &openbuff, OF_CREATE/*|OF_SHARE_DENY_WRITE*/)) == HFILE_ERROR)
	{
		AfxMessageBox("Can't open log file", IDOK|MB_ICONSTOP);
		return;
	}
	if (_llseek(handle, 0L, 0) == HFILE_ERROR)
	{
		_lclose(handle);
		AfxMessageBox("Can't read log file", IDOK|MB_ICONSTOP);
		return;
	}
	
	numitems = m_LBLogList.GetCount();
	
	// if list must be cropped, adjust number of items to write
	if (m_bLimit && (numitems > m_nLimit))
	{
		numitems = m_nLimit;
	}
	
	// write number of items
	if (_lwrite(handle, &numitems, sizeof(int)) == HFILE_ERROR)
	{
		_lclose(handle);
		AfxMessageBox("Can't read log file", IDOK|MB_ICONSTOP);
		return;
	}
	
	// write items
	for (i = numitems; i > 0; i--)
	{
		m_LBLogList.GetText(i-1, textbuf);
		if (_lwrite(handle, textbuf, 80) == HFILE_ERROR)
		{
			break;
		}
	}
	_lclose(handle);
}

////////////////////////////////////////////////////////////////////////////////////
// OnDelete(): Handler for Delete button
////////////////////////////////////////////////////////////////////////////////////
void CLogDlg::OnDelete()
{
	int nitems, i;
	HGLOBAL handle;
	LPINT pitems;
	
	nitems = m_LBLogList.GetSelCount();    // get number of selected items
	if (nitems == 0)
	{
		return;
	}
	
	// allocate a buffer to hold indices of all selected items
	if ((handle = GlobalAlloc(GMEM_MOVEABLE, nitems*sizeof(int))) == NULL)
	{
		return;
	}
	if ((pitems = (int*)GlobalLock(handle)) == NULL)
	{
		GlobalFree(handle);
		return;
	}
	
	// fill array with indices of selected items
	m_LBLogList.GetSelItems(nitems, pitems);
	
	for (i = nitems; i > 0; i--)
	{
		m_LBLogList.DeleteString(*(pitems+i-1));         // delete selected items
	}
	
	GlobalUnlock(handle);
	GlobalFree(handle);	
}

////////////////////////////////////////////////////////////////////////////////////
// OnDelete(): Handler for Delete all button
////////////////////////////////////////////////////////////////////////////////////
void CLogDlg::OnDeleteall()
{
	m_LBLogList.ResetContent();
}
