// headerst.cpp : implementation file
//

#include "stdafx.h"
#include "tricarb.h"   // include this before headerst.h
#include "headerst.h"
#include "comfns.h"

#include <string.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHeaderStringDlg dialog


CHeaderStringDlg::CHeaderStringDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CHeaderStringDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHeaderStringDlg)
	m_nOutFormat = 0;
	m_szHeadString = "";
	m_nTerminator = 0;
	//}}AFX_DATA_INIT
}

void CHeaderStringDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHeaderStringDlg)
	DDX_Control(pDX, IDC_HEADSTRING, m_HeadStringControl);
	DDX_CBIndex(pDX, IDC_FORMATE, m_nOutFormat);
	DDX_Text(pDX, IDC_HEADSTRING, m_szHeadString);
	DDV_MaxChars(pDX, m_szHeadString, 80);
	DDX_Radio(pDX, IDC_RADIO3, m_nTerminator);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CHeaderStringDlg, CDialog)
	//{{AFX_MSG_MAP(CHeaderStringDlg)
	ON_CBN_SELCHANGE(IDC_FORMATE, OnSelchangeFormate)
	ON_EN_KILLFOCUS(IDC_HEADSTRING, OnKillfocusHeadstring)
	ON_BN_CLICKED(IDC_RESETSTRING, OnResetstring)
	ON_BN_CLICKED(IDC_TAB, OnTab)
	ON_BN_CLICKED(IDC_RADIO1, OnRadio1)
	ON_BN_CLICKED(IDC_RADIO2, OnRadio2)
	ON_BN_CLICKED(IDC_RADIO3, OnRadio3)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CHeaderStringDlg message handlers

BOOL CHeaderStringDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	::CenterWindow(GetParent(), this);    // center dialog in frame window
	OnSelchangeFormate();                 // initialize edit control
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////
// OnSelchangeFormate(): Called when selection in listbox changes
/////////////////////////////////////////////////////////////////////////////
void CHeaderStringDlg::OnSelchangeFormate()
{
	UpdateData(TRUE);                               // retrieve m_nOutFormat
	m_szHeadString = &m_szHeader[m_nOutFormat][0];  // copy existing string into edit string
	m_nTerminator = m_nTerm[m_nOutFormat];
	UpdateData(FALSE);                              // and show result
}

/////////////////////////////////////////////////////////////////////////////
// OnKillfocusHeadstring(): Called when edit control loses input focus
/////////////////////////////////////////////////////////////////////////////
void CHeaderStringDlg::OnKillfocusHeadstring()
{
	UpdateData(TRUE);                                      // retrieve edit string
	strcpy(&m_szHeader[m_nOutFormat][0], m_szHeadString);  // copy edit string to string array
}

/////////////////////////////////////////////////////////////////////////////
// OnResetstring(): Called when Reset string button pressed
//                  Resets string to zero length
/////////////////////////////////////////////////////////////////////////////
void CHeaderStringDlg::OnResetstring()
{
	m_szHeadString = "";
	strcpy(&m_szHeader[m_nOutFormat][0], "");
	UpdateData(FALSE);
}

//////////////////////////////////////////////////////////////////////////////
// OnTab(): Called when Tab button pressed
//////////////////////////////////////////////////////////////////////////////
void CHeaderStringDlg::OnTab()
{
	m_HeadStringControl.ReplaceSel("\t");
	UpdateData(TRUE);
	m_HeadStringControl.SetFocus();
}


//////////////////////////////////////////////////////////////////////////////
// OnRadio1(): Called when Radio button pressed
//////////////////////////////////////////////////////////////////////////////
void CHeaderStringDlg::OnRadio1()
{
	UpdateData(TRUE);
	m_nTerm[m_nOutFormat] = m_nTerminator;
}

//////////////////////////////////////////////////////////////////////////////
// OnRadio2(): Called when Radio button pressed
//////////////////////////////////////////////////////////////////////////////
void CHeaderStringDlg::OnRadio2()
{
	UpdateData(TRUE);
	m_nTerm[m_nOutFormat] = m_nTerminator;
}

//////////////////////////////////////////////////////////////////////////////
// OnRadio3(): Called when Radio button pressed
//////////////////////////////////////////////////////////////////////////////
void CHeaderStringDlg::OnRadio3()
{
	UpdateData(TRUE);
	m_nTerm[m_nOutFormat] = m_nTerminator;
}
